/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201607.batchjob;

import com.google.api.ads.adwords.axis.utils.AxisDeserializer;
import com.google.api.ads.adwords.axis.utils.v201607.batchjob.BatchJobMutateRequest;
import com.google.api.ads.adwords.axis.utils.v201607.batchjob.BatchJobMutateResponse;
import com.google.api.ads.adwords.axis.utils.v201607.batchjob.ErrorList;
import com.google.api.ads.adwords.axis.utils.v201607.batchjob.MutateResult;
import com.google.api.ads.adwords.axis.v201607.cm.ApiError;
import com.google.api.ads.adwords.axis.v201607.cm.BatchJobOpsServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201607.cm.Operand;
import com.google.api.ads.adwords.axis.v201607.cm.Operation;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobHelperInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.adwords.lib.utils.BatchJobUploader;
import com.google.api.ads.adwords.lib.utils.logging.BatchJobLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.TypeMapping;

class BatchJobHelperImpl
implements BatchJobHelperInterface<Operation, Operand, ApiError, MutateResult, BatchJobMutateResponse> {
    private final BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse> uploader;
    private final BatchJobLogger batchJobLogger;
    private final QName resultQName;

    public BatchJobHelperImpl(AdWordsSession session) {
        this((BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse>)new BatchJobUploader(session, true));
    }

    @VisibleForTesting
    BatchJobHelperImpl(BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse> uploader) {
        this.uploader = uploader;
        this.batchJobLogger = AdWordsInternals.getInstance().getAdWordsServiceLoggers().getBatchJobLogger();
        this.resultQName = new QName("https://adwords.google.com/api/adwords/cm/v201607", "MutateResult");
    }

    public BatchJobUploadResponse uploadBatchJobOperations(Iterable<Operation> operations, String uploadUrl) throws BatchJobException {
        return this.uploadIncrementalBatchJobOperations(operations, true, new BatchJobUploadStatus(0L, URI.create(uploadUrl)));
    }

    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(Iterable<? extends Operation> operations, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        BatchJobMutateRequest request = new BatchJobMutateRequest();
        request.addOperations(operations);
        return this.uploader.uploadIncrementalBatchJobOperations((BatchJobMutateRequestInterface)request, isLastRequest, batchJobUploadStatus);
    }

    public BatchJobMutateResponse downloadBatchJobMutateResponse(String downloadUrl) throws BatchJobException {
        List<com.google.api.ads.adwords.axis.v201607.cm.MutateResult> cmMutateResults;
        AxisDeserializer deserializer = new AxisDeserializer();
        try {
            cmMutateResults = deserializer.deserializeBatchJobMutateResults(new URL(downloadUrl), BatchJobHelperImpl.getServiceTypeMappings(), com.google.api.ads.adwords.axis.v201607.cm.MutateResult.class, this.resultQName);
        }
        catch (Exception e) {
            this.batchJobLogger.logDownload(downloadUrl, null, (Throwable)e);
            throw new BatchJobException("Failed to download batch job mutate response from URL: " + downloadUrl, (Throwable)e);
        }
        BatchJobMutateResponse response = new BatchJobMutateResponse();
        ArrayList mutateResults = Lists.newArrayList();
        for (com.google.api.ads.adwords.axis.v201607.cm.MutateResult cmMutateResult : cmMutateResults) {
            MutateResult mutateResult = new MutateResult();
            mutateResult.setIndex(cmMutateResult.getIndex());
            mutateResult.setOperand(cmMutateResult.getResult());
            if (cmMutateResult.getErrorList() != null) {
                mutateResult.setErrorList(new ErrorList());
                if (cmMutateResult.getErrorList().getErrors() != null) {
                    mutateResult.getErrorList().setErrors(cmMutateResult.getErrorList().getErrors());
                }
            }
            mutateResults.add(mutateResult);
        }
        response.setMutateResults(mutateResults.toArray(new MutateResult[mutateResults.size()]));
        this.batchJobLogger.logDownload(downloadUrl, (BatchJobMutateResponseInterface)response, null);
        return response;
    }

    static List<TypeMapping> getServiceTypeMappings() {
        ImmutableList.Builder mappings = ImmutableList.builder();
        try {
            mappings.add((Object)new BatchJobOpsServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize service type mappings", e);
        }
        return mappings.build();
    }
}

