/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201601.batchjob;

import com.google.api.ads.adwords.axis.utils.AxisDeserializer;
import com.google.api.ads.adwords.axis.utils.v201601.batchjob.BatchJobMutateRequest;
import com.google.api.ads.adwords.axis.utils.v201601.batchjob.BatchJobMutateResponse;
import com.google.api.ads.adwords.axis.utils.v201601.batchjob.MutateResult;
import com.google.api.ads.adwords.axis.v201601.cm.AdGroupAdServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.AdGroupBidModifierServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.AdGroupCriterionServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.AdGroupServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.ApiError;
import com.google.api.ads.adwords.axis.v201601.cm.BudgetServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.CampaignCriterionServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.CampaignServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.FeedItemServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201601.cm.Operand;
import com.google.api.ads.adwords.axis.v201601.cm.Operation;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobHelperInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.adwords.lib.utils.BatchJobUploader;
import com.google.api.ads.adwords.lib.utils.logging.BatchJobLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.TypeMapping;

class BatchJobHelperImpl
implements BatchJobHelperInterface<Operation, Operand, ApiError, MutateResult, BatchJobMutateResponse> {
    private final BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse> uploader;
    private final BatchJobLogger batchJobLogger;
    private final QName resultQName;
    private final QName operandQName;

    public BatchJobHelperImpl(AdWordsSession session) {
        this((BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse>)new BatchJobUploader(session, true));
    }

    @VisibleForTesting
    BatchJobHelperImpl(BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse> uploader) {
        this.uploader = uploader;
        this.batchJobLogger = AdWordsInternals.getInstance().getAdWordsServiceLoggers().getBatchJobLogger();
        this.resultQName = new QName("https://adwords.google.com/api/adwords/cm/v201601", "MutateResult");
        this.operandQName = new QName("https://adwords.google.com/api/adwords/cm/v201601", "Operand");
    }

    public BatchJobUploadResponse uploadBatchJobOperations(Iterable<Operation> operations, String uploadUrl) throws BatchJobException {
        return this.uploadIncrementalBatchJobOperations(operations, true, new BatchJobUploadStatus(0L, URI.create(uploadUrl)));
    }

    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(Iterable<? extends Operation> operations, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        BatchJobMutateRequest request = new BatchJobMutateRequest();
        request.addOperations(operations);
        return this.uploader.uploadIncrementalBatchJobOperations((BatchJobMutateRequestInterface)request, isLastRequest, batchJobUploadStatus);
    }

    public BatchJobMutateResponse downloadBatchJobMutateResponse(String downloadUrl) throws BatchJobException {
        List<MutateResult> mutateResults;
        AxisDeserializer deserializer = new AxisDeserializer();
        try {
            mutateResults = deserializer.deserializeBatchJobMutateResults(new URL(downloadUrl), BatchJobHelperImpl.getServiceTypeMappings(), MutateResult.class, this.resultQName, Operand.class, this.operandQName);
        }
        catch (Exception e) {
            this.batchJobLogger.logDownload(downloadUrl, null, (Throwable)e);
            String string = String.valueOf(downloadUrl);
            throw new BatchJobException(string.length() != 0 ? "Failed to download batch job mutate response from URL: ".concat(string) : new String("Failed to download batch job mutate response from URL: "), (Throwable)e);
        }
        BatchJobMutateResponse response = new BatchJobMutateResponse();
        response.setMutateResults(mutateResults.toArray(new MutateResult[mutateResults.size()]));
        this.batchJobLogger.logDownload(downloadUrl, (BatchJobMutateResponseInterface)response, null);
        return response;
    }

    static List<TypeMapping> getServiceTypeMappings() {
        ImmutableList.Builder mappings = ImmutableList.builder();
        try {
            mappings.add((Object)new AdGroupAdServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new AdGroupBidModifierServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new AdGroupCriterionServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new AdGroupServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new BudgetServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new CampaignCriterionServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new CampaignServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
            mappings.add((Object)new FeedItemServiceSoapBindingStub(){

                public Call _createCall() throws ServiceException {
                    try {
                        return super.createCall();
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            }._createCall().getTypeMapping());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize service type mappings", e);
        }
        return mappings.build();
    }
}

