/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201109_1;

import com.google.api.ads.adwords.axis.utils.AxisReportDefinitionSerializer;
import com.google.api.ads.adwords.axis.v201109_1.cm.ReportDefinition;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.DefinedReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.LegacyErrorResponseHandler;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.common.annotations.VisibleForTesting;

public final class ReportDownloader {
    private static final String VERSION = "v201109_1";
    private final AdWordsSession session;
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;
    private final DefinedReportDownloadHelper definedReportDownloadHelper;
    private final AxisReportDefinitionSerializer<ReportDefinition> serializer;

    public ReportDownloader(AdWordsSession session) {
        this.adHocReportDownloadHelper = new AdHocReportDownloadHelper(session, VERSION);
        this.definedReportDownloadHelper = new DefinedReportDownloadHelper(session, VERSION);
        this.session = session;
        this.serializer = new AxisReportDefinitionSerializer<ReportDefinition>(ReportDefinition.class);
    }

    @Deprecated
    public ReportDownloadResponse downloadReport(long reportDefinitionId) throws ReportException {
        return this.definedReportDownloadHelper.downloadReport(reportDefinitionId);
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException {
        return new LegacyErrorResponseHandler().handleResponse(this.adHocReportDownloadHelper.downloadReport(this.toXml(reportDefinition)));
    }

    @VisibleForTesting
    String toXml(ReportDefinition reportDefinition) {
        return this.serializer.serialize(reportDefinition);
    }
}

