/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201109;

import com.google.api.ads.adwords.axis.v201109.cm.ReportDefinition;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.utils.StreamUtils;
import com.google.api.client.http.GenericUrl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;

public final class ReportUtils {
    private static final String DOWNLOAD_SERVER_URI = "/api/adwords/reportdownload";
    private static final String VERSION = "v201109";
    private static final String ERROR_MESSAGE_REGEX = "^.*!!![^|]*\\|\\|\\|([^|]*)\\|\\|\\|([^?]*)\\?\\?\\?.*$";
    private static final String REMOVE_ATTRIBUTES_REGEX = "( )?(xmlns|xsi):(\\w)+=\".*?\"|ns\\d:|<\\?xml.*?>";
    private static final String REMOVE_SELF_CLOSING_TAG = "<\\w+( )?/>";
    private static final String REPORT_BY_ID = "?__rd=%d";
    private static final int ERROR_MESSAGE_GROUP = 2;
    static final int REPORT_HEAD_LENGTH = 1024;
    private static final String REQUEST_METHOD = "POST";
    private static final String SUCCESS = "SUCCESS";

    private ReportUtils() {
    }

    static void checkForException(String reportHead) throws ReportException {
        Matcher matcher = Pattern.compile(ERROR_MESSAGE_REGEX).matcher(reportHead);
        if (matcher.matches()) {
            throw new ReportException(matcher.group(2));
        }
    }

    public static ReportDownloadResponse downloadReport(AdWordsSession adWordsSession, long reportDefinitionId) throws ReportException {
        try {
            String downloadUrl = ReportUtils.generateAdHocReportUrl(adWordsSession);
            downloadUrl = String.valueOf(downloadUrl) + String.format(REPORT_BY_ID, reportDefinitionId);
            HttpURLConnection conn = ReportUtils.getReportHttpUrlConnection(downloadUrl, adWordsSession);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            int status = conn.getResponseCode();
            String responseMessage = SUCCESS;
            InputStream inputStream = null;
            if (status == 200) {
                inputStream = conn.getInputStream();
            } else {
                responseMessage = new StreamUtils().readAll(conn.getErrorStream());
            }
            return new ReportDownloadResponse(status, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", (Throwable)e);
        }
    }

    public static ReportDownloadResponse downloadReport(AdWordsSession adWordsSession, ReportDefinition reportDefinition) throws ReportException {
        try {
            String downloadUrl = ReportUtils.generateAdHocReportUrl(adWordsSession);
            HttpURLConnection conn = ReportUtils.getReportHttpUrlConnection(downloadUrl, adWordsSession);
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setRequestMethod(REQUEST_METHOD);
            conn.setDoOutput(true);
            ReportUtils.writeReportToStream(conn.getOutputStream(), reportDefinition);
            int status = conn.getResponseCode();
            String responseMessage = SUCCESS;
            InputStream inputStream = null;
            if (status == 200) {
                inputStream = conn.getInputStream();
            } else {
                responseMessage = new StreamUtils().readAll(conn.getErrorStream());
            }
            return new ReportDownloadResponse(status, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", (Throwable)e);
        }
    }

    private static void writeReportToStream(OutputStream outputStream, ReportDefinition reportDefinition) throws UnsupportedEncodingException, IOException {
        String reportDefinitionXml = ReportUtils.toXml(reportDefinition);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write("__rdxml=" + URLEncoder.encode(reportDefinitionXml, "UTF-8"));
        writer.close();
    }

    private static String toXml(ReportDefinition reportDefinition) throws IOException {
        Serializer serializer = ReportDefinition.getSerializer("reportDefinition", ReportDefinition.class, ReportDefinition.getTypeDesc().getXmlType());
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext((Writer)writer);
        serializer.serialize(ReportDefinition.getTypeDesc().getXmlType(), null, (Object)reportDefinition, context);
        return ReportUtils.sanitize(writer.toString());
    }

    private static String sanitize(String string) {
        string = string.replaceAll(REMOVE_ATTRIBUTES_REGEX, "");
        string = string.replaceAll(REMOVE_SELF_CLOSING_TAG, "");
        string = string.replaceAll("ReportDefinition", "reportDefinition");
        return string;
    }

    private static String generateAdHocReportUrl(AdWordsSession session) {
        return String.valueOf(session.getEndpoint()) + DOWNLOAD_SERVER_URI + '/' + VERSION;
    }

    private static HttpURLConnection getReportHttpUrlConnection(String reportUrl, AdWordsSession adWordsSession) throws MalformedURLException, IOException, ReportException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(reportUrl).openConnection();
        httpUrlConnection.setRequestMethod(REQUEST_METHOD);
        if (adWordsSession.getClientLoginToken() != null) {
            httpUrlConnection.setRequestProperty("Authorization", "GoogleLogin auth=" + adWordsSession.getClientLoginToken());
        } else if (adWordsSession.getOAuthParameters() != null) {
            try {
                String authorizationHeader = new OAuthAuthorizationHeaderProvider(REQUEST_METHOD).getOAuthAuthorizationHeader(adWordsSession.getOAuthParameters(), new GenericUrl(reportUrl));
                httpUrlConnection.setRequestProperty("Authorization", authorizationHeader);
            }
            catch (OAuthException e) {
                throw new ReportException("Could not set OAuth header", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Either ClientLoginToken or OAuth header must be provided.");
        }
        httpUrlConnection.setRequestProperty("developerToken", adWordsSession.getDeveloperToken());
        httpUrlConnection.setRequestProperty("clientCustomerId", adWordsSession.getClientCustomerId());
        httpUrlConnection.setRequestProperty("returnMoneyInMicros", Boolean.toString(adWordsSession.isReportMoneyInMicros()));
        httpUrlConnection.setInstanceFollowRedirects(false);
        return httpUrlConnection;
    }
}

