/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;

public class ResponseInfo {
    private String payload;
    private String requestId;
    private Long operationsCount;
    private Long responseTimeMillis;

    private ResponseInfo() {
    }

    public String getPayload() {
        return this.payload;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Nullable
    public Long getOperationsCount() {
        return this.operationsCount;
    }

    @Nullable
    public Long getResponseTime() {
        return this.responseTimeMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestId", (Object)this.requestId).add("operationsCount", (Object)this.operationsCount).add("responseTimeMillis", (Object)this.responseTimeMillis).add("payload.length", Strings.nullToEmpty((String)this.payload).length()).toString();
    }

    public static class Builder {
        private ResponseInfo responseInfo = new ResponseInfo();

        @CanIgnoreReturnValue
        public Builder withPayload(String payload) {
            this.responseInfo.payload = payload;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRequestId(String requestId) {
            this.responseInfo.requestId = requestId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withOperationsCount(@Nullable Long operationsCount) {
            this.responseInfo.operationsCount = operationsCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withResponseTimeMillis(@Nullable Long responseTimeMillis) {
            this.responseInfo.responseTimeMillis = responseTimeMillis;
            return this;
        }

        public ResponseInfo build() {
            return this.responseInfo;
        }
    }
}

