/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class SoapClientHandler<T>
implements SoapClientHandlerInterface<T> {
    protected SoapClientHandler() {
    }

    protected Object[] processSoapArguments(Method soapClientMethod, Object[] args) {
        if (args == null) {
            return null;
        }
        int argsCount = Math.max(soapClientMethod.getParameterTypes().length, args.length);
        return Arrays.copyOf(args, argsCount);
    }

    @Override
    public Method getSoapClientMethod(T soapClient, Method method) throws NoSuchMethodException {
        for (Method soapClientMethod : soapClient.getClass().getMethods()) {
            if (!method.getName().equals(soapClientMethod.getName()) || !method.getReturnType().equals(soapClientMethod.getReturnType())) continue;
            return soapClientMethod;
        }
        throw new NoSuchMethodException("No method named " + method.getName() + " with return type " + method.getReturnType() + " found.");
    }

    protected Object invoke(SoapCall<T> soapCall) throws Exception {
        Method soapClientMethod = soapCall.getSoapClientMethod();
        Object[] soapArgs = soapCall.getSoapArgs();
        soapArgs = this.processSoapArguments(soapClientMethod, soapArgs);
        return soapClientMethod.invoke(soapCall.getSoapClient(), soapArgs);
    }
}

