/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.lib.client;

import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.Configuration;

public class AdManagerSession
implements AdsSession,
OAuth2Compatible {
    private String networkCode;
    private Credential oAuth2Credential;
    private final String applicationName;
    private final String endpoint;
    public static final String DEFAULT_ENDPOINT = "https://ads.google.com/";
    private static final String DEFAULT_APPLICATION_NAME = "INSERT_APPLICATION_NAME_HERE";

    private AdManagerSession(Builder builder) {
        this.applicationName = builder.applicationName;
        this.endpoint = builder.endpoint;
        this.networkCode = builder.networkCode;
        this.oAuth2Credential = builder.oAuth2Credential;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<AdManagerSession> {
        private String applicationName;
        private String endpoint;
        private String networkCode;
        private Credential oAuth2Credential;
        private final ConfigurationHelper configHelper = new ConfigurationHelper();

        public Builder() {
        }

        private Builder(AdManagerSession adManagerSessionToClone) {
            this();
            this.applicationName = adManagerSessionToClone.getApplicationName();
            this.endpoint = adManagerSessionToClone.getEndpoint();
            this.networkCode = adManagerSessionToClone.getNetworkCode();
            this.oAuth2Credential = adManagerSessionToClone.getOAuth2Credential();
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        @CanIgnoreReturnValue
        public Builder from(Configuration config) {
            this.applicationName = config.getString("api.admanager.applicationName", null);
            this.networkCode = config.getString("api.admanager.networkCode", null);
            this.endpoint = config.getString("api.admanager.endpoint", null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.clearAuthentication();
            this.oAuth2Credential = oAuth2Credential;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private void clearAuthentication() {
            this.oAuth2Credential = null;
        }

        @Override
        public AdManagerSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new AdManagerSession(this);
        }

        public ImmutableAdManagerSession buildImmutable() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new ImmutableAdManagerSession(this);
        }

        private void defaultOptionals() {
            if (this.endpoint == null) {
                this.endpoint = AdManagerSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate() throws ValidationException {
            if (this.oAuth2Credential == null) {
                throw new ValidationException("OAuth2 authentication must be used.", "");
            }
            if (Strings.nullToEmpty((String)this.applicationName).trim().isEmpty() || this.applicationName.contains(AdManagerSession.DEFAULT_APPLICATION_NAME)) {
                throw new ValidationException(String.format("Application name must be set and not be the default [%s]", AdManagerSession.DEFAULT_APPLICATION_NAME), "applicationName");
            }
            try {
                URL uRL = new URL(this.endpoint);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", this.endpoint), "endpoint", e);
            }
        }
    }

    @ThreadSafe
    public static final class ImmutableAdManagerSession
    extends AdManagerSession {
        private ImmutableAdManagerSession(Builder builder) {
            super(builder);
        }

        private void throwUnsupportedOperationException(String attributeName) {
            throw new UnsupportedOperationException(String.format("Cannot set %s. ImmutableAdManagerSession is immutable.", attributeName));
        }

        @Override
        public void setOAuth2Credential(Credential oAuth2Credential) {
            this.throwUnsupportedOperationException("oAuth2Credential");
        }

        @Override
        public void setNetworkCode(String networkCode) {
            this.throwUnsupportedOperationException("networkCode");
        }
    }
}

