/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.client.RemoteCallReturn;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.api.ads.common.lib.utils.logging.RemoteCallLoggerDelegate;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsServiceLoggers {
    public static final Logger ADS_API_LIB_LOG = LoggerFactory.getLogger((String)(AdsServiceLoggers.class.getName() + ".ads_api_lib"));
    private final RemoteCallLoggerDelegate loggerDelegate;

    @Inject
    private AdsServiceLoggers(PrettyPrinterInterface prettyPrinter, @Named(value="soapXmlLogger") Logger soapXmlLogger, @Named(value="requestInfoLogger") Logger requestInfoLogger) {
        this(new RemoteCallLoggerDelegate(requestInfoLogger, soapXmlLogger, prettyPrinter, RemoteCallLoggerDelegate.RemoteCallType.SOAP));
    }

    AdsServiceLoggers(RemoteCallLoggerDelegate loggerDelegate) {
        this.loggerDelegate = loggerDelegate;
    }

    public void logRequest(RemoteCallReturn remoteCallReturn) {
        this.loggerDelegate.logRequestSummary(remoteCallReturn);
        this.loggerDelegate.logRequestDetails(remoteCallReturn);
    }
}

