/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CsvFiles {
    private CsvFiles() {
    }

    public static Map<String, String> getCsvDataMap(String fileName, int key, int value, boolean headerPresent) throws IOException {
        HashMap result = Maps.newHashMap();
        new CsvReader(fileName, headerPresent).processReader((header, line, lineNumber) -> result.put(line[key], line[value]));
        return result;
    }

    public static Map<String, String> getCsvDataMap(String fileName, boolean headerPresent) throws IOException {
        return CsvFiles.getCsvDataMap(fileName, 0, 1, headerPresent);
    }

    public static Map<String, String[]> getCsvDataMapArray(String fileName, boolean headerPresent) throws IOException {
        HashMap result = Maps.newHashMap();
        new CsvReader(fileName, headerPresent).processReader((header, line, lineNumber) -> result.put(line[0], Arrays.asList(line).subList(1, line.length).toArray(new String[line.length - 1])));
        return result;
    }

    public static List<Map<String, String>> getCsvDataListMap(String fileName, boolean headerPresent) throws IOException {
        ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader((headers, line, lineNumber) -> {
            HashMap data = Maps.newHashMap();
            for (int i = 0; i < line.length; ++i) {
                if (headers != null) {
                    data.put(headers[i], line[i]);
                    continue;
                }
                data.put(i + "", line[i]);
            }
            result.add(data);
        });
        return result;
    }

    public static List<String> getCsvDataByColumn(String fileName, int column, boolean headerPresent) throws IOException {
        ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader((headers, line, lineNumber) -> result.add(line[column]));
        return result;
    }

    public static List<String[]> getCsvDataArray(String fileName, boolean headerPresent) throws IOException {
        ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader((headers, line, lineNumber) -> result.add(line));
        return result;
    }

    public static List<String[]> getCsvDataArray(Reader csvReader, boolean headerPresent) throws IOException {
        ArrayList result = Lists.newArrayList();
        new CsvReader(new CSVReader(csvReader), headerPresent).processReader((headers, line, lineNumber) -> result.add(line));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsv(List<String[]> csvData, String fileName) throws IOException {
        Preconditions.checkNotNull(csvData, (Object)"Null CSV data");
        Preconditions.checkNotNull((Object)fileName, (Object)"Null file name");
        try (CSVWriter writer = null;){
            writer = new CSVWriter((Writer)Files.newWriter((File)new File(fileName), (Charset)StandardCharsets.UTF_8));
            for (String[] line : csvData) {
                writer.writeNext(line);
            }
        }
    }

    private static class CsvReader {
        private final String fileName;
        private final boolean headerPresent;
        private CSVReader reader;
        private String[] header;
        private int lineNumber;

        public CsvReader(String fileName, boolean headerPresent) {
            this.fileName = fileName;
            this.headerPresent = headerPresent;
        }

        public CsvReader(CSVReader reader, boolean headerPresent) {
            this.fileName = null;
            this.reader = reader;
            this.headerPresent = headerPresent;
        }

        private void createCsvReader() throws IOException {
            this.lineNumber = 1;
            if (this.reader == null) {
                this.reader = new CSVReader((Reader)Files.newReader((File)new File(this.fileName), (Charset)StandardCharsets.UTF_8));
            }
            if (this.headerPresent) {
                this.header = this.reader.readNext();
                ++this.lineNumber;
            }
        }

        public void processReader(CsvWorker worker) throws IOException {
            this.createCsvReader();
            try {
                String[] line;
                while ((line = this.reader.readNext()) != null) {
                    worker.processLine(this.header, line, this.lineNumber);
                    ++this.lineNumber;
                }
            }
            finally {
                this.reader.close();
            }
        }

        private static interface CsvWorker {
            public void processLine(String[] var1, String[] var2, int var3);
        }
    }
}

