/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.admanager.lib.utils.AdManagerInternals;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.common.lib.auth.OAuth2Helper;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.utils.Internals;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

public class OfflineCredentials {
    private final HttpTransport httpTransport;
    private final String refreshToken;
    private final String clientId;
    private final String clientSecret;
    private final OAuth2Helper oAuth2Helper;
    private final String tokenServerUrl;
    private final String jsonKeyFilePath;
    private final List<String> scopes;
    private final String serviceAccountUser;

    private OfflineCredentials(ForApiBuilder builder) {
        this.httpTransport = builder.httpTransport;
        this.refreshToken = builder.refreshToken;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.oAuth2Helper = builder.oAuth2Helper;
        this.tokenServerUrl = builder.tokenServerUrl;
        this.jsonKeyFilePath = builder.jsonKeyFilePath;
        this.scopes = builder.scopes;
        this.serviceAccountUser = builder.serviceAccountUser;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getJsonKeyFilePath() {
        return this.jsonKeyFilePath;
    }

    @VisibleForTesting
    final String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    public Credential generateCredential() throws OAuthException {
        GoogleCredential credential = Strings.isNullOrEmpty((String)this.jsonKeyFilePath) ? this.generateCredentialFromClientSecrets() : this.generateCredentialFromKeyFile();
        try {
            if (!this.oAuth2Helper.callRefreshToken((Credential)credential)) {
                throw new OAuthException("Credential could not be refreshed. A newly generated refresh token or secret key may be required.");
            }
        }
        catch (IOException e) {
            throw new OAuthException("Credential could not be refreshed.", e);
        }
        return credential;
    }

    private GoogleCredential generateCredentialFromKeyFile() throws OAuthException {
        try {
            File jsonKeyFile = new File(this.jsonKeyFilePath);
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)Files.asByteSource((File)jsonKeyFile).openStream(), (HttpTransport)this.httpTransport, (JsonFactory)new JacksonFactory()).createScoped(this.scopes);
            if (Strings.isNullOrEmpty((String)this.serviceAccountUser)) {
                return credential;
            }
            return new GoogleCredential.Builder().setJsonFactory(credential.getJsonFactory()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTransport(credential.getTransport()).setServiceAccountUser(this.serviceAccountUser).build();
        }
        catch (IOException e) {
            throw new OAuthException("Service account key file could not be loaded.", e);
        }
    }

    private GoogleCredential generateCredentialFromClientSecrets() {
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory((JsonFactory)new JacksonFactory()).setClientSecrets(this.clientId, this.clientSecret).setTokenServerEncodedUrl(this.tokenServerUrl).build();
        credential.setRefreshToken(this.refreshToken);
        return credential;
    }

    public static class ForApiBuilder
    implements com.google.api.ads.common.lib.utils.Builder<OfflineCredentials> {
        @VisibleForTesting
        static final HttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport();
        private HttpTransport httpTransport;
        private String refreshToken;
        private String clientId;
        private String clientSecret;
        private String configFilePath;
        private String tokenServerUrl;
        private String jsonKeyFilePath;
        private String serviceAccountUser;
        private List<String> scopes;
        private final ConfigurationHelper configHelper;
        private final OAuthConfig oAuthConfig;
        private final OAuth2Helper oAuth2Helper;

        private ForApiBuilder(OAuthConfig oAuthConfig, OAuth2Helper oAuth2Helper) {
            this(new ConfigurationHelper(), oAuthConfig, oAuth2Helper);
        }

        @VisibleForTesting
        ForApiBuilder(ConfigurationHelper configHelper, OAuthConfig oAuthConfig, OAuth2Helper oAuth2Helper) {
            this.configHelper = configHelper;
            this.oAuthConfig = oAuthConfig;
            this.oAuth2Helper = oAuth2Helper;
        }

        public ForApiBuilder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.toString());
        }

        public ForApiBuilder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.getAbsolutePath());
        }

        public ForApiBuilder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path), path.toString());
        }

        public ForApiBuilder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public ForApiBuilder from(Configuration config) {
            this.refreshToken = config.getString(this.getPropertyKey("refreshToken"), null);
            this.clientId = config.getString(this.getPropertyKey("clientId"), null);
            this.clientSecret = config.getString(this.getPropertyKey("clientSecret"), null);
            this.jsonKeyFilePath = config.getString(this.getPropertyKey("jsonKeyFilePath"), null);
            this.serviceAccountUser = config.getString(this.getPropertyKey("serviceAccountUser"), null);
            return this;
        }

        ForApiBuilder from(Configuration config, String filePath) {
            this.from(config);
            this.configFilePath = filePath;
            return this;
        }

        public ForApiBuilder withClientSecrets(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public ForApiBuilder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public ForApiBuilder withJsonKeyFilePath(String jsonKeyFilePath) {
            this.jsonKeyFilePath = jsonKeyFilePath;
            return this;
        }

        public ForApiBuilder withServiceAccountUser(String serviceAccountUser) {
            this.serviceAccountUser = serviceAccountUser;
            return this;
        }

        public ForApiBuilder withScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public ForApiBuilder withHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ForApiBuilder withTokenUrlServer(String tokenServerUrl) {
            this.tokenServerUrl = tokenServerUrl;
            return this;
        }

        private void validate() throws ValidationException {
            if (!Strings.isNullOrEmpty((String)this.jsonKeyFilePath)) {
                boolean otherOAuthPropsSet;
                boolean bl = otherOAuthPropsSet = !Strings.isNullOrEmpty((String)this.clientId) || !Strings.isNullOrEmpty((String)this.clientSecret) || !Strings.isNullOrEmpty((String)this.refreshToken);
                if (otherOAuthPropsSet) {
                    throw new ValidationException("Multiple OAuth formats set. Please specify either a service account key file or a client ID and secret, not both.", this.configFilePath != null ? this.generateFilePathWarning("jsonKeyFilePath") : ".");
                }
                return;
            }
            if (!Strings.isNullOrEmpty((String)this.serviceAccountUser)) {
                throw new ValidationException("Service account user set, but no service account key file was specified.", "serviceAccountUser");
            }
            if (Strings.isNullOrEmpty((String)this.clientId)) {
                throw new ValidationException(String.format("Client ID must be set%s%nIf you do not have a client ID or secret, please create one in the API console: https://console.developers.google.com/project", this.configFilePath != null ? this.generateFilePathWarning("clientId") : "."), "clientId");
            }
            if (Strings.isNullOrEmpty((String)this.clientSecret)) {
                throw new ValidationException(String.format("Client secret must be set%s%nIf you do not have a client ID or secret, please create one in the API console: https://console.developers.google.com/project", this.configFilePath != null ? this.generateFilePathWarning("clientSecret") : "."), "clientSecret");
            }
            if (Strings.isNullOrEmpty((String)this.refreshToken)) {
                throw new ValidationException(String.format("A refresh token must be set%s%nIt is required for offline credentials. If you need to create one, see the GetRefreshToken example.", this.configFilePath != null ? this.generateFilePathWarning("refreshToken") : "."), "refreshToken");
            }
        }

        private String generateFilePathWarning(String key) {
            return String.format(" as %s in %s.", this.getPropertyKey(key), this.configFilePath);
        }

        private void defaultOptionals() {
            if (this.httpTransport == null) {
                this.httpTransport = DEFAULT_HTTP_TRANSPORT;
            }
            if (this.tokenServerUrl == null) {
                this.tokenServerUrl = "https://oauth2.googleapis.com/token";
            }
            if (this.scopes == null) {
                this.scopes = Lists.newArrayList((Object[])new String[]{this.oAuthConfig.getScope()});
            }
        }

        @Override
        public OfflineCredentials build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new OfflineCredentials(this);
        }

        private String getPropertyKey(String suffix) {
            return this.oAuthConfig.getPropertyKeyPrefix() + suffix;
        }
    }

    public static class Builder {
        @Nullable
        private OAuth2Helper oAuth2Helper;

        public Builder() {
            this(null);
        }

        @VisibleForTesting
        Builder(@Nullable OAuth2Helper oAuth2Helper) {
            this.oAuth2Helper = oAuth2Helper;
        }

        public ForApiBuilder forApi(OAuthConfig oAuthConfig) {
            this.defaultOptionals(oAuthConfig);
            return new ForApiBuilder(oAuthConfig, this.oAuth2Helper);
        }

        private void defaultOptionals(OAuthConfig oAuthConfig) {
            if (this.oAuth2Helper == null) {
                this.oAuth2Helper = oAuthConfig.getInternals().getOAuth2Helper();
            }
        }
    }

    public static class CustomOAuthConfig
    implements OAuthConfig {
        private String propKeyPrefix;
        private String scope;
        private Internals internals;

        public CustomOAuthConfig(String propKeyPrefix, String scope, Internals internals) {
            this.propKeyPrefix = propKeyPrefix;
            this.scope = scope;
            this.internals = internals;
        }

        @Override
        public String getPropertyKeyPrefix() {
            return this.propKeyPrefix;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public Internals getInternals() {
            return this.internals;
        }
    }

    public static enum Api implements OAuthConfig
    {
        ADWORDS("api.adwords.", "https://www.googleapis.com/auth/adwords"),
        AD_MANAGER("api.admanager.", "https://www.googleapis.com/auth/dfp");

        private final String propKeyPrefix;
        private final String scope;

        private Api(String propKeyPrefix, String scope) {
            this.propKeyPrefix = (String)Preconditions.checkNotNull((Object)propKeyPrefix, (String)"Null property key prefix for: %s", (Object)this);
            this.scope = (String)Preconditions.checkNotNull((Object)scope, (String)"Null scope for: %s", (Object)this);
        }

        @Override
        public String getPropertyKeyPrefix() {
            return this.propKeyPrefix;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public Internals getInternals() {
            switch (this) {
                case ADWORDS: {
                    return AdWordsInternals.getInstance();
                }
                case AD_MANAGER: {
                    return AdManagerInternals.getInstance();
                }
            }
            return null;
        }
    }

    public static interface OAuthConfig {
        public String getPropertyKeyPrefix();

        public String getScope();

        public Internals getInternals();
    }
}

