/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;

public class RequestInfo {
    private String payload;
    private String serviceName;
    private String methodName;
    private String url;
    private String contextName;
    private String contextValue;

    private RequestInfo() {
    }

    public String getPayload() {
        return this.payload;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextValue() {
        return this.contextValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.serviceName).add("methodName", (Object)this.methodName).add("url", (Object)this.url).add("contextName", (Object)this.contextName).add("contextValue", (Object)this.contextValue).add("payload.length", Strings.nullToEmpty((String)this.payload).length()).toString();
    }

    public static class Builder {
        private RequestInfo requestInfo = new RequestInfo();

        public Builder withMethodName(String methodName) {
            this.requestInfo.methodName = methodName;
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.requestInfo.serviceName = serviceName;
            return this;
        }

        public Builder withPayload(String payload) {
            this.requestInfo.payload = payload;
            return this;
        }

        public Builder withUrl(String url) {
            this.requestInfo.url = url;
            return this;
        }

        public Builder withContext(String contextName, String contextValue) {
            this.requestInfo.contextName = contextName;
            this.requestInfo.contextValue = contextValue;
            return this;
        }

        public RequestInfo build() {
            return this.requestInfo;
        }
    }
}

