/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.name.Named;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;

public class OAuth2Helper {
    private final Long refreshWindowSeconds;
    private final Logger libLogger;

    @Inject
    public OAuth2Helper(@Named(value="libLogger") Logger libLogger, @Named(value="oAuth2RefreshWindow") Long refreshWindowSeconds) {
        this.libLogger = libLogger;
        this.refreshWindowSeconds = refreshWindowSeconds;
    }

    public Credential refreshCredential(Credential credential) throws IOException {
        if (this.isCredentialRefreshable(credential) && !this.callRefreshToken(credential)) {
            this.libLogger.warn("OAuth2 token could not be refreshed. Add a refreshListener to the Credential to capture this failure.");
        }
        return credential;
    }

    boolean callRefreshToken(Credential credential) throws IOException {
        return credential.refreshToken();
    }

    @VisibleForTesting
    boolean isCredentialRefreshable(Credential credential) {
        return credential.getAccessToken() == null || credential.getExpiresInSeconds() != null && credential.getExpiresInSeconds() <= this.refreshWindowSeconds;
    }
}

