// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.api.ads.admanager.lib.utils.examples;

/** Contains command line argument formats for example code. */
public final class ArgumentNames {

  public static final String ACTIVITY_ID = "--activityId";

  public static final String ACTIVITY_GROUP_ID = "--activityGroupId";

  public static final String AD_UNIT_ID = "--adUnitId";

  public static final String ADVERTISER_COMPANY_ID = "--advertiserCompanyId";

  public static final String ADVERTISER_ID = "--advertiserId";

  public static final String AGENCY_ID = "--agencyId";

  public static final String AUDIENCE_SEGMENT_ID = "--audienceSegmentId";

  public static final String BASE_RATE_ID = "--baseRateId";

  public static final String BUYER_ID = "--buyerId";

  public static final String COMPANION_CREATIVE_ID = "--companionCreativeId";

  public static final String COMPANY_ID = "--companyId";

  public static final String CONTACT_ID = "--contactId";

  public static final String CONTENT_ID = "--contentId";

  public static final String CONTENT_BUNDLE_ID = "--contentBundleId";

  public static final String CREATIVE_ID = "--creativeId";

  public static final String CREATIVE_SET_ID = "--creativeSetId";

  public static final String CREATIVE_WRAPPER_ID = "--creativeWrapperId";

  public static final String CURRENCY_CODE = "--currencyCode";

  public static final String CUSTOM_DIMENSION_KEY_ID = "--customDimensionKeyId";

  public static final String CUSTOM_FIELD_ID = "--customFieldId";

  public static final String FIELD_OPTION_ID = "--fieldOptionId";

  public static final String TARGETING_KEY_ID = "--targetingKeyId";

  public static final String TARGETING_KEY_ID_1 = "--targetingKeyId1";

  public static final String TARGETING_KEY_ID_2 = "--targetingKeyId2";

  public static final String TARGETING_KEY_ID_3 = "--targetingKeyId3";

  public static final String TARGETING_VALUE_ID = "--targetingValueId";

  public static final String TARGETING_VALUE_ID_1 = "--targetingValueId1";

  public static final String TARGETING_VALUE_IDS_2 = "--targetingValueId2";

  public static final String TARGETING_VALUE_ID_3 = "--targetingValueId3";

  public static final String EMAIL_ADDRESS = "--emailAddress";

  public static final String EXCHANGE_RATE_ID = "--exchangeRateId";

  public static final String HIERARCHY_LEVEL_ONE_KEY_ID = "--hierarchyLevelOneKeyId";

  public static final String HIERARCHY_LEVEL_TWO_KEY_ID = "--hierarchyLevelTwoKeyId";

  public static final String LABEL_ID = "--labelId";

  public static final String LINE_ITEM_ID = "--lineItemId";

  public static final String MASTER_CREATIVE_ID = "--masterCreativeId";

  public static final String NAME = "--name";

  public static final String NUMBER_CUSTOM_FIELD_ID = "--numberCustomFieldId";

  public static final String NUM_REQUESTS = "--numRequests";

  public static final String ORDER_ID = "--orderId";

  public static final String PACKAGE_ID = "--packageId";

  public static final String PARENT_AD_UNIT_ID = "--parentAdUnitId";

  public static final String PLACEMENT_ID = "--placementId";

  public static final String PREMIUM_RATE_ID = "--premiumRateId";

  public static final String PRIMARY_SALESPERSON_ID = "--primarySalespersonId";

  public static final String PRIMARY_TRAFFICKER_ID = "--primaryTraffickerId";

  public static final String PRODUCT_ID = "--productId";

  public static final String PRODUCT_PACKAGE_ID = "--productPackageId";

  public static final String PRODUCT_PACKAGE_ITEM_ID = "--productPackageItemId";

  public static final String PRODUCT_TEMPLATE_ID = "--productTemplateId";

  public static final String PROGRAMMATIC_BUYER_ID = "--programmaticBuyerId";

  public static final String PROPOSAL_ID = "--proposalId";

  public static final String PROPOSAL_LINE_ITEM_ID = "--proposalLineItemId";

  public static final String RATE_CARD_ID = "--rateCardId";

  public static final String RECONCILIATION_LINE_ITEM_REPORT_ID =
      "--reconciliationLineItemReportId";

  public static final String RECONCILIATION_ORDER_REPORT_ID = "--reconciliationOrderReportId";

  public static final String RECONCILIATION_REPORT_ID = "--reconciliationReportId";

  public static final String RECONCILIATION_REPORT_ROW_ID = "--reconciliationReportRowId";

  public static final String SAVED_QUERY_ID = "--savedQueryId";

  public static final String SECONDARY_SALESPERSON_ID = "--secondarySalespersonId";

  public static final String TARGETED_VIDEO_AD_UNIT_ID = "--targetedVideoAdUnitId";

  public static final String TEAM_ID = "--teamId";

  public static final String TRAFFICKER_ID = "--traffickerId";

  public static final String USER_ID = "--userId";

  public static final String ADJUSTMENT_ID = "--adjustmentId";

  public static final String CMS_METADATA_VALUE_ID = "--cmsMetadataValueId";

  public static final String CMS_METADATA_KEY_NAME = "--cmsMetadataKeyName";

  public static final String CMS_METADATA_KEY_ID = "--cmsMetadataKeyId";

  public static final String TRAFFIC_FORECAST_SEGMENT_ID = "--trafficForecastSegmentId";

  public static final String SITE_ID = "--siteId";

  public static final String CHILD_NETWORK_CODE = "--childNetworkCode";

  public static final String URL = "--url";
}
