/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.useragent;

import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.useragent.UserAgentProvider;
import com.google.api.ads.common.lib.utils.AdsUtility;
import com.google.api.ads.common.lib.utils.AdsUtilityRegistry;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;

public class AdsUtilitiesUserAgentProvider
implements UserAgentProvider {
    private final AdsUtilityRegistry adsUtilityRegistry;
    private final AdsLibConfiguration adsLibConfiguration;
    private static final Function<AdsUtility, String> ADS_UTILITY_FUNCTION = input -> input == null ? null : input.getUserAgentIdentifier();

    @Inject
    public AdsUtilitiesUserAgentProvider(AdsUtilityRegistry adsUtilityRegistry, AdsLibConfiguration adsLibConfiguration) {
        this.adsUtilityRegistry = adsUtilityRegistry;
        this.adsLibConfiguration = adsLibConfiguration;
    }

    @Override
    public String getUserAgent() {
        Set<AdsUtility> adsUtilities = this.adsUtilityRegistry.popRegisteredUtilities();
        if (!this.adsLibConfiguration.isIncludeAdsUtilitiesInUserAgent() || adsUtilities.isEmpty()) {
            return null;
        }
        return Joiner.on((String)", ").skipNulls().join((Iterable)Sets.newTreeSet((Iterable)Collections2.transform(adsUtilities, ADS_UTILITY_FUNCTION)));
    }
}

