/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.client.RemoteCallReturn;
import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class RemoteCallLoggerDelegate {
    private final Logger summaryLogger;
    private final Logger detailLogger;
    private final PrettyPrinterInterface prettyPrinter;
    private final RemoteCallType remoteCallType;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile(String.format("%n", new Object[0]), 16);
    @VisibleForTesting
    static final String SUMMARY_TEMPLATE = "Request made: Service: {} Method: {} {}: {} URL: {} Request ID: {} ResponseTime(ms): {} OperationsCount: {} IsFault: {} FaultMessage: {}";
    @VisibleForTesting
    static final String DETAILS_REQUEST_TEMPLATE = String.format("{} request:%n{}", new Object[0]);
    @VisibleForTesting
    static final String DETAILS_RESPONSE_TEMPLATE = String.format("{} response:%n{}", new Object[0]);
    private static final int MAX_SUMMARY_ERROR_LENGTH = 16000;
    private static final String ELLIPSIS = "...";

    public RemoteCallLoggerDelegate(Logger summaryLogger, Logger detailLogger, @Nullable PrettyPrinterInterface prettyPrinter, RemoteCallType remoteCallType) {
        this.summaryLogger = (Logger)Preconditions.checkNotNull((Object)summaryLogger, (Object)"Null summary logger");
        this.detailLogger = (Logger)Preconditions.checkNotNull((Object)detailLogger, (Object)"Null detail logger");
        this.prettyPrinter = (PrettyPrinterInterface)MoreObjects.firstNonNull((Object)prettyPrinter, (Object)PrettyPrinterInterface.NO_OP_PRETTY_PRINTER);
        this.remoteCallType = (RemoteCallType)((Object)Preconditions.checkNotNull((Object)((Object)remoteCallType), (Object)"Null remote call type"));
    }

    public boolean isSummaryLoggable(boolean isSuccess) {
        if (isSuccess) {
            return this.summaryLogger.isInfoEnabled();
        }
        return this.summaryLogger.isWarnEnabled();
    }

    public boolean isDetailsLoggable(boolean isSuccess) {
        if (isSuccess) {
            return this.detailLogger.isDebugEnabled();
        }
        return this.detailLogger.isInfoEnabled();
    }

    public void logRequestDetails(RemoteCallReturn remoteCallReturn) {
        boolean isSuccess;
        if (remoteCallReturn == null) {
            return;
        }
        boolean bl = isSuccess = remoteCallReturn.getException() == null;
        if (!this.isDetailsLoggable(isSuccess)) {
            return;
        }
        String prettyRequest = null;
        if (remoteCallReturn.getRequestInfo() != null) {
            prettyRequest = this.prettyPrinter.prettyPrint(remoteCallReturn.getRequestInfo().getPayload());
        }
        String prettyResponse = null;
        if (remoteCallReturn.getResponseInfo() != null) {
            prettyResponse = this.prettyPrinter.prettyPrint(remoteCallReturn.getResponseInfo().getPayload());
        }
        if (isSuccess) {
            this.detailLogger.debug(DETAILS_REQUEST_TEMPLATE, (Object)this.remoteCallType, (Object)prettyRequest);
            this.detailLogger.debug(DETAILS_RESPONSE_TEMPLATE, (Object)this.remoteCallType, (Object)prettyResponse);
        } else {
            this.detailLogger.info(DETAILS_REQUEST_TEMPLATE, (Object)this.remoteCallType, (Object)prettyRequest);
            this.detailLogger.info(DETAILS_RESPONSE_TEMPLATE, (Object)this.remoteCallType, (Object)prettyResponse);
        }
    }

    public void logRequestSummary(RemoteCallReturn remoteCallReturn) {
        boolean isSuccess;
        if (remoteCallReturn == null) {
            return;
        }
        boolean bl = isSuccess = remoteCallReturn.getException() == null;
        if (!this.isSummaryLoggable(isSuccess)) {
            return;
        }
        RequestInfo request = remoteCallReturn.getRequestInfo();
        ResponseInfo response = remoteCallReturn.getResponseInfo();
        Object[] logArgs = new Object[10];
        if (request != null) {
            logArgs[0] = request.getServiceName();
            logArgs[1] = request.getMethodName();
            logArgs[2] = request.getContextName();
            logArgs[3] = request.getContextValue();
            logArgs[4] = request.getUrl();
        }
        if (response != null) {
            logArgs[5] = response.getRequestId();
            logArgs[6] = response.getResponseTime();
            logArgs[7] = response.getOperationsCount();
            Throwable throwable = remoteCallReturn.getException();
            logArgs[8] = throwable != null;
            logArgs[9] = this.truncateThrowable(throwable, 16000);
        }
        if (isSuccess) {
            this.summaryLogger.info(SUMMARY_TEMPLATE, logArgs);
        } else {
            this.summaryLogger.warn(SUMMARY_TEMPLATE, logArgs);
        }
    }

    @VisibleForTesting
    CharSequence truncateThrowable(Throwable throwable, int maxLength) {
        if (throwable == null) {
            return null;
        }
        String truncated = NEWLINE_PATTERN.matcher(throwable.toString()).replaceAll("");
        if (truncated.length() <= maxLength) {
            return truncated;
        }
        return new StringBuilder(maxLength).append(truncated.substring(0, maxLength - ELLIPSIS.length())).append(ELLIPSIS).toString();
    }

    public static enum RemoteCallType {
        SOAP,
        HTTP;

    }
}

