/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.utils.IterableXPath;
import com.google.api.ads.common.lib.utils.NodeExtractor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class RequestInfoXPathSet {
    private final IterableXPath contextXPath;
    private final String contextName;
    private final NodeExtractor nodeExtractor;

    @Inject
    public RequestInfoXPathSet(AdsApiConfiguration apiConfig, NodeExtractor nodeExtractor) {
        this.contextXPath = new IterableXPath(apiConfig.getRequestContextXPath());
        this.contextName = Iterables.isEmpty((Iterable)this.contextXPath) ? null : (String)Iterables.getLast((Iterable)this.contextXPath);
        this.nodeExtractor = nodeExtractor;
    }

    public IterableXPath getContextXPath() {
        return this.contextXPath;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("contextName", (Object)this.contextName).add("contextXPath", (Object)this.contextXPath).toString();
    }

    public RequestInfo.Builder parseMessage(RequestInfo.Builder builder, SOAPMessage soapMessage) {
        Preconditions.checkNotNull((Object)builder, (Object)"Null builder");
        if (soapMessage == null) {
            return builder;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            soapMessage.writeTo((OutputStream)outputStream);
            builder.withPayload(outputStream.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException | SOAPException e) {
            builder.withPayload("Unable to read request content due to exception: " + e);
        }
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            builder.withContext(this.contextName, this.nodeExtractor.extractNodeValue((Node)soapHeader, this.contextXPath));
        }
        catch (SOAPException e) {
            builder.withContext(this.contextName, "Unable to extract " + this.contextName + " from request due to exception: " + (Object)((Object)e));
        }
        return builder;
    }
}

