/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.api.ads.common.lib.utils.AdsUtility;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@Singleton
@ThreadSafe
public final class AdsUtilityRegistry {
    private final Set<AdsUtility> adsUtilities = Sets.newConcurrentHashSet();
    private static final AdsUtilityRegistry INSTANCE = new AdsUtilityRegistry();

    public static AdsUtilityRegistry getInstance() {
        return INSTANCE;
    }

    private AdsUtilityRegistry() {
    }

    public void addUtility(AdsUtility adsUtility) {
        this.adsUtilities.add((AdsUtility)((Object)Preconditions.checkNotNull((Object)((Object)adsUtility), (Object)"Null ads utility")));
    }

    public Set<AdsUtility> getRegisteredUtilities() {
        return Sets.newHashSet(this.adsUtilities);
    }

    public void removeUtilities(Collection<AdsUtility> utilities) {
        this.adsUtilities.removeAll((Collection)Preconditions.checkNotNull(utilities, (Object)"Null utilities collection"));
    }
}

