/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationProvider;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

public abstract class ConfigurationModule
extends AbstractModule {
    private static final String BUILD_PROPERTIES = "props/google-ads-api-java-build.properties";

    protected void configure() {
    }

    protected void configureConfigurations(Class<? extends AdsApiConfiguration> apiConfigurationClass, @Nullable List<URL> apiPropertyUrls, @Nullable List<String> apiPropertyFilePaths, Class<? extends AdsLibConfiguration> adsLibConfigurationClass, @Nullable List<URL> libPropertyUrls, @Nullable List<String> libPropertyFilePaths, List<URL> productPropertyUrls) {
        this.bind(AdsApiConfiguration.class).to(apiConfigurationClass).asEagerSingleton();
        this.bind(AdsLibConfiguration.class).to(adsLibConfigurationClass).asEagerSingleton();
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"api")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(apiPropertyUrls, false), ConfigurationHelper.newList(apiPropertyFilePaths, true)));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"lib")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(libPropertyUrls, false), this.getFilePathConfigurationListWithDefault(libPropertyFilePaths, "ads.properties")));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"build")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(Lists.newArrayList((Object[])new URL[]{ConfigurationModule.class.getResource(BUILD_PROPERTIES)}), false), null));
        this.bind(Configuration.class).annotatedWith((Annotation)Names.named((String)"product")).toProvider((Provider)new ConfigurationProvider(ConfigurationHelper.newList(productPropertyUrls, false), null));
    }

    private List<ConfigurationHelper.ConfigurationInfo<String>> getFilePathConfigurationListWithDefault(@Nullable List<String> filePaths, String defaultFilePath) {
        List<ConfigurationHelper.ConfigurationInfo<String>> defaultConfigList = ConfigurationHelper.newList(true, defaultFilePath);
        List<ConfigurationHelper.ConfigurationInfo<String>> filePathConfigList = ConfigurationHelper.newList(filePaths, true);
        if (defaultConfigList != null) {
            if (filePathConfigList == null) {
                filePathConfigList = defaultConfigList;
            } else {
                filePathConfigList.addAll(defaultConfigList);
            }
        }
        return filePathConfigList;
    }
}

