/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.useragent;

import com.google.api.ads.common.lib.useragent.AdsLibraryUserAgentProvider;
import com.google.api.ads.common.lib.useragent.AdsUtilitiesUserAgentProvider;
import com.google.api.ads.common.lib.useragent.BuildTypeUserAgentProvider;
import com.google.api.ads.common.lib.useragent.FrameworkUserAgentProvider;
import com.google.api.ads.common.lib.useragent.ProductFrameworkUserAgentProvider;
import com.google.api.ads.common.lib.useragent.ProductUserAgentProvider;
import com.google.api.ads.common.lib.useragent.RuntimeUserAgentProvider;
import com.google.api.ads.common.lib.useragent.UserAgentProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class UserAgentCombiner {
    private ImmutableList<UserAgentProvider> userAgentProviders;

    @Inject
    public UserAgentCombiner(ProductUserAgentProvider productUserAgentProvider, ProductFrameworkProviderHolder productFrameworkProviderHolder, AdsLibraryUserAgentProvider adsLibraryUserAgentProvider, FrameworkProviderHolder frameworkProviderHolder, RuntimeUserAgentProvider runtimeUserAgentProvider, BuildTypeUserAgentProvider buildTypeUserAgentProvider, AdsUtilitiesUserAgentProvider adsUtilitiesUserAgentProvider) {
        this(Lists.newArrayList((Object[])new UserAgentProvider[]{productUserAgentProvider, productFrameworkProviderHolder.value, adsLibraryUserAgentProvider, frameworkProviderHolder.value, runtimeUserAgentProvider, buildTypeUserAgentProvider, adsUtilitiesUserAgentProvider}));
    }

    @VisibleForTesting
    UserAgentCombiner(List<UserAgentProvider> userAgentProviders) {
        this.userAgentProviders = ImmutableList.copyOf((Collection)Collections2.filter(userAgentProviders, (Predicate)Predicates.notNull()));
    }

    public String getUserAgent(String nonLibraryUserAgent) {
        StringBuilder agentStringBuilder = new StringBuilder();
        agentStringBuilder.append(nonLibraryUserAgent);
        agentStringBuilder.append(" (");
        agentStringBuilder.append(Joiner.on((String)", ").skipNulls().join(Iterables.transform(this.userAgentProviders, (Function)new Function<UserAgentProvider, String>(){

            public String apply(@Nullable UserAgentProvider input) {
                return input == null ? null : input.getUserAgent();
            }
        })));
        agentStringBuilder.append(')');
        return agentStringBuilder.toString();
    }

    static class FrameworkProviderHolder {
        @Inject(optional=true)
        FrameworkUserAgentProvider value;

        FrameworkProviderHolder() {
        }
    }

    static class ProductFrameworkProviderHolder {
        @Inject(optional=true)
        ProductFrameworkUserAgentProvider value;

        ProductFrameworkProviderHolder() {
        }
    }
}

