/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.logging;

import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResultInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class BatchJobLogger {
    private final Logger batchJobLogger;
    @VisibleForTesting
    static final String SUCCESS_STATUS = "SUCCESSFUL";
    @VisibleForTesting
    static final String FAILURE_STATUS = "FAILED";

    @Inject
    BatchJobLogger(@Named(value="batch_job") Logger batchJobLogger) {
        this.batchJobLogger = batchJobLogger;
    }

    public void logUpload(String uploadContents, Object uploadUri, @Nullable BatchJobUploadResponse batchJobUploadResponse, @Nullable Throwable throwable) {
        boolean isSuccess = throwable == null;
        String httpResponseInfo = null;
        if (batchJobUploadResponse != null) {
            httpResponseInfo = String.format("%d: %s", batchJobUploadResponse.getHttpStatus(), batchJobUploadResponse.getHttpResponseMessage());
        }
        String resultString = String.format("%s (%s)", isSuccess ? SUCCESS_STATUS : FAILURE_STATUS, httpResponseInfo);
        if (isSuccess) {
            this.batchJobLogger.info("{} batch job upload to {}", (Object)resultString, uploadUri);
        } else {
            this.batchJobLogger.warn("{} batch job upload to {}. Exception: {}", new Object[]{resultString, uploadUri, throwable});
        }
        if (this.batchJobLogger.isDebugEnabled()) {
            this.batchJobLogger.debug("Contents for {} upload to {}: {}", new Object[]{resultString, uploadUri, uploadContents == null ? null : uploadContents.trim()});
        }
    }

    public <O, E, R extends BatchJobMutateResultInterface<O, E>> void logDownload(String downloadUrl, BatchJobMutateResponseInterface<O, E, R> response, Throwable throwable) {
        boolean isSuccess;
        boolean bl = isSuccess = throwable == null;
        if (isSuccess) {
            this.batchJobLogger.info("{} download of {} mutate results from batch job download URL {}", new Object[]{SUCCESS_STATUS, response == null || response.getMutateResults() == null ? 0 : response.getMutateResults().length, downloadUrl});
        } else {
            this.batchJobLogger.warn("{} to download mutate results from batch job download URL {}. Exception: {}", new Object[]{FAILURE_STATUS, downloadUrl, throwable});
        }
    }
}

