/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.api.ads.common.lib.soap.compatability.JaxWsCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.MalformedURLException;
import java.net.URL;

public class AdWordsServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible,
JaxWsCompatible {
    private final Class<?> interfaceClass;
    private final String version;
    private final AdWordsApiConfiguration apiConfig;

    @Inject
    public AdWordsServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version, AdWordsApiConfiguration apiConfig) {
        this.interfaceClass = interfaceClass;
        this.version = version;
        this.apiConfig = apiConfig;
    }

    @Override
    public Class<?> getInterfaceClass() throws ServiceException {
        return this.interfaceClass;
    }

    @Override
    public String getEndpointAddress(String endpointServer) throws MalformedURLException {
        String serviceName = this.getServiceName();
        String endpointServerUrl = new URL(endpointServer).toString();
        if (endpointServerUrl.endsWith("/")) {
            endpointServerUrl = endpointServerUrl.substring(0, endpointServerUrl.length() - 1);
        }
        String string = endpointServerUrl;
        String string2 = this.apiConfig.getServiceUrlGroup(this.version, serviceName);
        String string3 = this.version;
        return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(serviceName).length()).append(string).append("/api/adwords/").append(string2).append("/").append(string3).append("/").append(serviceName).toString();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        String string = String.valueOf(this.interfaceClass.getPackage().getName());
        String string2 = this.getServiceName();
        return Class.forName(new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).append("Locator").toString());
    }

    @Override
    public Class<?> getServiceClass() throws ClassNotFoundException {
        String string = String.valueOf(this.interfaceClass.getPackage().getName());
        String string2 = this.getServiceName();
        return Class.forName(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
    }

    @VisibleForTesting
    String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        return simpleName.substring(0, simpleName.indexOf("Interface"));
    }

    public String getPackageGroup() {
        String packageName = this.interfaceClass.getPackage().getName();
        String[] parts = packageName.split("\\.");
        return parts[parts.length - 1];
    }

    public AdWordsSubProduct getSubProduct() {
        return this.apiConfig.getServiceSubProduct(this.version, this.getServiceName());
    }

    public static enum AdWordsSubProduct {
        DEFAULT,
        EXPRESS;

    }
}

