/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.client;

import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class DfaServiceDescriptor
implements AdsServiceDescriptor,
AxisCompatible {
    private final Class<?> interfaceClass;
    private final String version;

    @Inject
    public DfaServiceDescriptor(@Assisted(value="interfaceClass") Class<?> interfaceClass, @Assisted(value="version") String version) {
        this.interfaceClass = interfaceClass;
        this.version = version;
    }

    @Override
    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public Class<?> getLocatorClass() throws ClassNotFoundException {
        return Class.forName(String.valueOf(this.interfaceClass.getCanonicalName()).concat("ServiceLocator"));
    }

    @VisibleForTesting
    protected String getServiceName() {
        String simpleName = this.interfaceClass.getSimpleName();
        String serviceName = simpleName.substring(0, simpleName.indexOf("Remote")).toLowerCase();
        if ("placementstrategy".equalsIgnoreCase(serviceName)) {
            return "strategy";
        }
        return serviceName;
    }

    @Override
    public String getEndpointAddress(String endpointServer) {
        String string = this.version;
        String string2 = this.getServiceName();
        return new StringBuilder(14 + String.valueOf(endpointServer).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(endpointServer).append("/").append(string).append("/api/dfa-api/").append(string2).toString();
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

