/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201607;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.jaxb.v201607.DownloadFormat;
import com.google.api.ads.adwords.lib.jaxb.v201607.ReportDefinition;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.v201607.AwqlReportRequest;
import com.google.api.ads.adwords.lib.utils.v201607.DetailedReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.v201607.XmlReportDefinitionRequest;
import com.google.common.annotations.VisibleForTesting;

public class ReportDownloader {
    private static final String VERSION = "v201607";
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;

    public ReportDownloader(AdWordsSession session) {
        this(new AdHocReportDownloadHelper(session, VERSION));
    }

    @VisibleForTesting
    ReportDownloader(AdHocReportDownloadHelper adHocReportDownloadHelper) {
        this.adHocReportDownloadHelper = adHocReportDownloadHelper;
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException, ReportDownloadResponseException {
        return this.adHocReportDownloadHelper.downloadReport(new XmlReportDefinitionRequest(reportDefinition), new DetailedReportDownloadResponseException.Builder());
    }

    public ReportDownloadResponse downloadReport(String reportQuery, DownloadFormat format) throws ReportException, ReportDownloadResponseException {
        return this.adHocReportDownloadHelper.downloadReport(new AwqlReportRequest(reportQuery, format), new DetailedReportDownloadResponseException.Builder());
    }

    public int getReportDownloadTimeout() {
        return this.adHocReportDownloadHelper.getReportDownloadTimeout();
    }

    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.adHocReportDownloadHelper.setReportDownloadTimeout(reportDownloadTimeout);
    }
}

