/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;

public class ReportDownloadResponse {
    private static final String HTTP_SUCCESS_MESSAGE = "SUCCESS";
    private final RawReportDownloadResponse rawResponse;

    public ReportDownloadResponse(RawReportDownloadResponse rawResponse) {
        this.rawResponse = (RawReportDownloadResponse)Preconditions.checkNotNull((Object)rawResponse, (Object)"Null raw response");
        Preconditions.checkArgument((rawResponse.getHttpStatus() == 200 ? 1 : 0) != 0, (String)"Expected a successful raw response but raw response status is: %s", (int)rawResponse.getHttpStatus());
    }

    public int getHttpStatus() {
        return this.rawResponse.getHttpStatus();
    }

    public String getHttpResponseMessage() {
        return HTTP_SUCCESS_MESSAGE;
    }

    @Nullable
    public InputStream getInputStream() {
        return this.rawResponse.getInputStream();
    }

    public String getAsString() throws IOException {
        InputStream inputStream = this.isGzipped() ? new GZIPInputStream(this.getInputStream()) : this.getInputStream();
        return Streams.readAll(inputStream, this.rawResponse.getCharset());
    }

    public void saveToFile(String outputFile) throws FileNotFoundException, IOException {
        Streams.copy(this.getInputStream(), new BufferedOutputStream(new FileOutputStream(outputFile)));
    }

    private boolean isGzipped() {
        return this.rawResponse.getDownloadFormat().startsWith("GZIPPED");
    }
}

