/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201409;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.jaxb.v201409.DownloadFormat;
import com.google.api.ads.adwords.lib.jaxb.v201409.ReportDefinition;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.XmlFieldExtractor;
import com.google.api.ads.adwords.lib.utils.v201409.AwqlReportRequest;
import com.google.api.ads.adwords.lib.utils.v201409.DetailedReportDownloadResponseException;
import com.google.api.ads.adwords.lib.utils.v201409.XmlReportDefinitionRequest;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

public class ReportDownloader {
    private static final String VERSION = "v201409";
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;

    public ReportDownloader(AdWordsSession session) {
        this(new AdHocReportDownloadHelper(session, VERSION));
    }

    @VisibleForTesting
    ReportDownloader(AdHocReportDownloadHelper adHocReportDownloadHelper) {
        this.adHocReportDownloadHelper = adHocReportDownloadHelper;
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException, ReportDownloadResponseException {
        return this.handleResponse(this.adHocReportDownloadHelper.downloadReport(new XmlReportDefinitionRequest(reportDefinition)));
    }

    private ReportDownloadResponse handleResponse(RawReportDownloadResponse response) throws ReportDownloadResponseException {
        String responseText;
        if (response.getHttpStatus() == 200) {
            return new ReportDownloadResponse(response);
        }
        try {
            responseText = Streams.readAll(response.getInputStream(), response.getCharset());
        }
        catch (IOException e1) {
            throw new ReportDownloadResponseException(response.getHttpStatus(), (Throwable)e1);
        }
        DetailedReportDownloadResponseException exception = new DetailedReportDownloadResponseException(response.getHttpStatus(), responseText);
        XmlFieldExtractor extractor = new XmlFieldExtractor();
        Map<String, String> fields = extractor.extract(new ByteArrayInputStream(responseText.getBytes()), new String[]{"fieldPath", "trigger", "type"});
        exception.setFieldPath(fields.get("fieldPath"));
        exception.setTrigger(fields.get("trigger"));
        exception.setType(fields.get("type"));
        throw exception;
    }

    public ReportDownloadResponse downloadReport(String reportQuery, DownloadFormat format) throws ReportException, ReportDownloadResponseException {
        return this.handleResponse(this.adHocReportDownloadHelper.downloadReport(new AwqlReportRequest(reportQuery, format)));
    }

    public int getReportDownloadTimeout() {
        return this.adHocReportDownloadHelper.getReportDownloadTimeout();
    }

    public void setReportDownloadTimeout(int reportDownloadTimeout) {
        this.adHocReportDownloadHelper.setReportDownloadTimeout(reportDownloadTimeout);
    }
}

