/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CsvFiles {
    private CsvFiles() {
    }

    public static Map<String, String> getCsvDataMap(String fileName, final int key, final int value, boolean headerPresent) throws IOException {
        final HashMap result = Maps.newHashMap();
        new CsvReader(fileName, headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] header, String[] line, int lineNumber) {
                result.put(line[key], line[value]);
            }
        });
        return result;
    }

    public static Map<String, String> getCsvDataMap(String fileName, boolean headerPresent) throws IOException {
        return CsvFiles.getCsvDataMap(fileName, 0, 1, headerPresent);
    }

    public static Map<String, String[]> getCsvDataMapArray(String fileName, boolean headerPresent) throws IOException {
        final HashMap result = Maps.newHashMap();
        new CsvReader(fileName, headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] header, String[] line, int lineNumber) {
                result.put(line[0], Arrays.asList(line).subList(1, line.length).toArray(new String[line.length - 1]));
            }
        });
        return result;
    }

    public static List<Map<String, String>> getCsvDataListMap(String fileName, boolean headerPresent) throws IOException {
        final ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] headers, String[] line, int lineNumber) {
                HashMap data = Maps.newHashMap();
                int i = 0;
                while (i < line.length) {
                    if (headers != null) {
                        data.put(headers[i], line[i]);
                    } else {
                        data.put(String.valueOf(i), line[i]);
                    }
                    ++i;
                }
                result.add(data);
            }
        });
        return result;
    }

    public static List<String> getCsvDataByColumn(String fileName, final int column, boolean headerPresent) throws IOException {
        final ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] headers, String[] line, int lineNumber) {
                result.add(line[column]);
            }
        });
        return result;
    }

    public static List<String[]> getCsvDataArray(String fileName, boolean headerPresent) throws IOException {
        final ArrayList result = Lists.newArrayList();
        new CsvReader(fileName, headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] headers, String[] line, int lineNumber) {
                result.add(line);
            }
        });
        return result;
    }

    public static List<String[]> getCsvDataArray(Reader csvReader, boolean headerPresent) throws IOException {
        final ArrayList result = Lists.newArrayList();
        new CsvReader(new CSVReader(csvReader), headerPresent).processReader(new CsvReader.CsvWorker(){

            @Override
            public void processLine(String[] headers, String[] line, int lineNumber) {
                result.add(line);
            }
        });
        return result;
    }

    public static void writeCsv(List<String[]> csvData, String fileName) throws IOException {
        Preconditions.checkNotNull(csvData, (Object)"Cannot write null CSV data to file.");
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new FileWriter(fileName));
            for (String[] line : csvData) {
                writer.writeNext(line);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static class CsvReader {
        private final String fileName;
        private final boolean headerPresent;
        private CSVReader reader;
        private String[] header;
        private int lineNumber;

        public CsvReader(String fileName, boolean headerPresent) {
            this.fileName = fileName;
            this.headerPresent = headerPresent;
        }

        public CsvReader(CSVReader reader, boolean headerPresent) {
            this.fileName = null;
            this.reader = reader;
            this.headerPresent = headerPresent;
        }

        private void createCsvReader() throws IOException {
            this.lineNumber = 1;
            if (this.reader == null) {
                this.reader = new CSVReader((Reader)new FileReader(this.fileName));
            }
            if (this.headerPresent) {
                this.header = this.reader.readNext();
                ++this.lineNumber;
            }
        }

        public void processReader(CsvWorker worker) throws IOException {
            this.createCsvReader();
            try {
                String[] line;
                while ((line = this.reader.readNext()) != null) {
                    worker.processLine(this.header, line, this.lineNumber);
                    ++this.lineNumber;
                }
            }
            finally {
                this.reader.close();
            }
        }

        private static interface CsvWorker {
            public void processLine(String[] var1, String[] var2, int var3);
        }
    }
}

