/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxb;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.lang.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxBSerializer<T> {
    private final Class<T> clazz;
    private final QName qname;
    private final JAXBContext jaxbContext;

    public JaxBSerializer(Class<T> clazz, QName qname) {
        this.clazz = clazz;
        this.qname = qname;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new SerializationException("Could not serialize object.", (Throwable)e);
        }
    }

    public String serialize(T object) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            JAXBElement element = new JAXBElement(this.qname, this.clazz, object);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new SerializationException("Could not serialize object.", (Throwable)e);
        }
    }
}

