/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapCallReturn;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoapServiceClient<T>
implements InvocationHandler {
    private final SoapClientHandlerInterface<T> soapClientHandler;
    private final T soapClient;

    protected SoapServiceClient(SoapClientHandlerInterface<T> soapClientHandler, T soapClient) {
        this.soapClient = soapClient;
        this.soapClientHandler = soapClientHandler;
    }

    protected synchronized SoapCallReturn callSoapClient(SoapCall<T> soapCall) {
        return this.soapClientHandler.invokeSoapCall(soapCall);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.setHeaders();
            SoapCallReturn soapCallReturn = this.callSoapClient(this.createSoapCall(this.soapClientHandler.getSoapClientMethod(this.soapClient, method), args));
            this.logSoapCall(soapCallReturn);
            return this.unwrapSoapCallReturn(soapCallReturn);
        }
    }

    protected SoapCall<T> createSoapCall(Method soapClientMethod, Object[] args) {
        return new SoapCall<T>(soapClientMethod, this.soapClient, args);
    }

    public void setEndpointAddress(String endpointAddress) {
        this.soapClientHandler.setEndpointAddress(this.soapClient, endpointAddress);
    }

    public Object getSoapClient() {
        return this.soapClient;
    }

    protected SoapClientHandlerInterface<T> getSoapClientHandler() {
        return this.soapClientHandler;
    }

    protected abstract void logSoapCall(SoapCallReturn var1);

    protected abstract void setHeaders() throws ServiceException, AuthenticationException;

    protected Throwable handleException(Throwable e) {
        return e;
    }

    protected Object unwrapSoapCallReturn(SoapCallReturn soapCallReturn) throws Throwable {
        if (soapCallReturn.getException() != null) {
            throw this.handleException(soapCallReturn.getException());
        }
        return soapCallReturn.getReturnValue();
    }
}

