/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.soap.SoapServiceClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsServiceClientFactory<C extends AdsServiceClient<S, D>, S extends AdsSession, D extends AdsServiceDescriptor> {
    private final AdsServiceClientFactoryHelper<C, S, D> adsServiceFactoryHelper;

    @Inject
    public AdsServiceClientFactory(AdsServiceClientFactoryHelper adsServiceClientFactoryHelper) {
        this.adsServiceFactoryHelper = adsServiceClientFactoryHelper;
    }

    public synchronized <T> T getServiceClient(S adsSession, Class<T> interfaceClass) throws ServiceException {
        String version = this.adsServiceFactoryHelper.determineVersion(interfaceClass);
        D adsServiceDescriptor = this.adsServiceFactoryHelper.createServiceDescriptor(interfaceClass, version);
        C adsServiceClient = this.adsServiceFactoryHelper.createAdsServiceClient(adsServiceDescriptor, adsSession);
        return this.createServiceClientProxy(adsServiceDescriptor, adsServiceClient);
    }

    @VisibleForTesting
    protected <T> T createServiceClientProxy(D adsServiceDescriptor, C adsServiceClient) {
        HashSet interfaces = new HashSet();
        Collections.addAll(interfaces, adsServiceClient.getClass().getInterfaces());
        interfaces.add(adsServiceDescriptor.getInterfaceClass());
        return this.createProxy(adsServiceClient, interfaces);
    }

    <T> T createProxy(C adsServiceClient, Set<Class<?>> interfaces) {
        Object proxy = Proxy.newProxyInstance(((SoapServiceClient)adsServiceClient).getSoapClient().getClass().getClassLoader(), interfaces.toArray(new Class[0]), adsServiceClient);
        return (T)proxy;
    }
}

