/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.useragent;

import com.google.api.ads.common.lib.useragent.AdsLibraryUserAgentProvider;
import com.google.api.ads.common.lib.useragent.BuildTypeUserAgentProvider;
import com.google.api.ads.common.lib.useragent.FrameworkUserAgentProvider;
import com.google.api.ads.common.lib.useragent.ProductFrameworkUserAgentProvider;
import com.google.api.ads.common.lib.useragent.ProductUserAgentProvider;
import com.google.api.ads.common.lib.useragent.RuntimeUserAgentProvider;
import com.google.api.ads.common.lib.useragent.UserAgentProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentCombiner {
    private List<UserAgentProvider> userAgentProviders;

    @Inject
    public UserAgentCombiner(ProductUserAgentProvider productUserAgentProvider, ProductFrameworkProviderHolder productFrameworkProviderHolder, AdsLibraryUserAgentProvider adsLibraryUserAgentProvider, FrameworkProviderHolder frameworkProviderHolder, RuntimeUserAgentProvider runtimeUserAgentProvider, BuildTypeUserAgentProvider buildTypeUserAgentProvider) {
        this(Lists.newArrayList((Object[])new UserAgentProvider[]{productUserAgentProvider, productFrameworkProviderHolder.value, adsLibraryUserAgentProvider, frameworkProviderHolder.value, runtimeUserAgentProvider, buildTypeUserAgentProvider}));
    }

    @VisibleForTesting
    UserAgentCombiner(List<UserAgentProvider> userAgentProviders) {
        this.userAgentProviders = userAgentProviders;
    }

    public String getUserAgent(String nonLibraryUserAgent) {
        return String.valueOf(nonLibraryUserAgent) + " (" + Joiner.on((String)", ").skipNulls().join((Iterable)Lists.transform(this.userAgentProviders, (Function)new Function<UserAgentProvider, String>(){

            public String apply(@Nullable UserAgentProvider input) {
                return input == null ? null : input.getUserAgent();
            }
        })) + ")";
    }

    static class FrameworkProviderHolder {
        @Inject(optional=true)
        FrameworkUserAgentProvider value;

        FrameworkProviderHolder() {
        }
    }

    static class ProductFrameworkProviderHolder {
        @Inject(optional=true)
        ProductFrameworkUserAgentProvider value;

        ProductFrameworkProviderHolder() {
        }
    }
}

