/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.common.lib.auth.ClientLoginCompatible;
import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;

public class AdWordsSession
implements AdsSession,
OAuth2Compatible,
ClientLoginCompatible {
    static final String DEPRECATION_MESSAGE = "ClientLogin is now deprecated. Please switch to OAuth2. See OfflineCredentials for more information.";
    private String clientLoginToken;
    private String clientCustomerId;
    private Boolean isValidateOnly;
    private Boolean isReportMoneyInMicros;
    private Boolean isPartialFailure;
    private Credential oAuth2Credential;
    private final String userAgent;
    private final String developerToken;
    private final String endpoint;
    private final Logger libLogger;
    public static final String DEFAULT_ENDPOINT = "https://adwords.google.com/";

    private AdWordsSession(Builder builder) {
        this.clientCustomerId = builder.clientCustomerId;
        this.developerToken = builder.developerToken;
        this.endpoint = builder.endpoint;
        this.isPartialFailure = builder.isPartialFailure;
        this.isReportMoneyInMicros = builder.isReportMoneyInMicros;
        this.isValidateOnly = builder.isValidateOnly;
        this.oAuth2Credential = builder.oAuth2Credential;
        this.userAgent = builder.userAgent;
        this.libLogger = builder.libLogger;
        if (builder.clientLoginToken != null) {
            this.setClientLoginToken(builder.clientLoginToken);
        }
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public void setClientCustomerId(String clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
    }

    @Nullable
    public Boolean isValidateOnly() {
        return this.isValidateOnly;
    }

    public void setValidateOnly(@Nullable Boolean isValidateOnly) {
        this.isValidateOnly = isValidateOnly;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDeveloperToken() {
        return this.developerToken;
    }

    @Nullable
    public Boolean isPartialFailure() {
        return this.isPartialFailure;
    }

    public void setPartialFailure(@Nullable Boolean isPartialFailure) {
        this.isPartialFailure = isPartialFailure;
    }

    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    @Deprecated
    public String getClientLoginToken() {
        return this.clientLoginToken;
    }

    @Deprecated
    public void setClientLoginToken(String clientLoginToken) {
        Preconditions.checkNotNull((Object)clientLoginToken, (Object)"clientLoginToken cannot be null.");
        this.clearAuthentication();
        this.clientLoginToken = clientLoginToken;
        this.libLogger.warn(DEPRECATION_MESSAGE);
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
        this.clientLoginToken = null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setReportMoneyInMicros(@Nullable Boolean reportMoneyInMicros) {
        this.isReportMoneyInMicros = reportMoneyInMicros;
    }

    @Nullable
    public Boolean isReportMoneyInMicros() {
        return this.isReportMoneyInMicros;
    }

    /* synthetic */ AdWordsSession(Builder builder, AdWordsSession adWordsSession) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<AdWordsSession> {
        private String endpoint;
        private String clientLoginToken;
        private String userAgent;
        private String developerToken;
        private String clientCustomerId;
        private Boolean isPartialFailure;
        private Boolean isValidateOnly;
        private Boolean isReportMoneyInMicros = Boolean.FALSE;
        private Credential oAuth2Credential;
        private final Logger libLogger;
        private final ConfigurationHelper configHelper;

        public Builder() {
            this(AdWordsInternals.getInstance().getAdsServiceLoggers().getLibLogger());
        }

        @VisibleForTesting
        Builder(Logger libLogger) {
            this(libLogger, new ConfigurationHelper());
        }

        private Builder(Logger libLogger, ConfigurationHelper configHelper) {
            this.libLogger = libLogger;
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.clientCustomerId = config.getString("api.adwords.clientCustomerId", null);
            this.userAgent = config.getString("api.adwords.userAgent", null);
            this.developerToken = config.getString("api.adwords.developerToken", null);
            this.isPartialFailure = config.getBoolean("api.adwords.isPartialFailure", null);
            this.endpoint = config.getString("api.adwords.endpoint", null);
            this.isReportMoneyInMicros = config.getBoolean("api.adwords.reportMoneyInMicros", Boolean.FALSE);
            this.clientLoginToken = config.getString("api.adwords.clientLoginToken", null);
            return this;
        }

        @Deprecated
        public Builder withClientLoginToken(String clientLoginToken) {
            this.clearAuthentication();
            this.clientLoginToken = clientLoginToken;
            return this;
        }

        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.clearAuthentication();
            this.oAuth2Credential = oAuth2Credential;
            return this;
        }

        public Builder withDeveloperToken(String developerToken) {
            this.developerToken = developerToken;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withClientCustomerId(String clientCustomerId) {
            this.clientCustomerId = clientCustomerId;
            return this;
        }

        public Builder enablePartialFailure() {
            this.isPartialFailure = true;
            return this;
        }

        public Builder enableReportMoneyInMicros() {
            this.isReportMoneyInMicros = true;
            return this;
        }

        private void clearAuthentication() {
            this.oAuth2Credential = null;
            this.clientLoginToken = null;
        }

        @Override
        public AdWordsSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate();
            return new AdWordsSession(this, null);
        }

        private void defaultOptionals() {
            if (this.endpoint == null) {
                this.endpoint = AdWordsSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate() throws ValidationException {
            if (this.clientLoginToken == null && this.oAuth2Credential == null) {
                throw new ValidationException("ClientLogin or OAuth2 authentication must be used.", "");
            }
            if (this.developerToken == null) {
                throw new ValidationException("A developer token must be set.", "developerToken");
            }
            try {
                new URL(this.endpoint);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", this.endpoint), "endpoint", e);
            }
        }
    }
}

