/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.auth.OAuth2AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.ads.dfp.lib.client.DfpServiceDescriptor;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.ads.dfp.lib.conf.DfpApiConfiguration;
import com.google.api.ads.dfp.lib.conf.DfpBuildConfiguration;
import com.google.api.client.http.GenericUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfpAxisHeaderHandler
implements HeaderHandler<DfpSession, DfpServiceDescriptor> {
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider;
    private final OAuth2AuthorizationHeaderProvider oAuth2AuthorizationHeaderProvider;
    private final DfpApiConfiguration dfpApiConfiguration;
    private final DfpBuildConfiguration dfpBuildConfiguration;

    @Inject
    public DfpAxisHeaderHandler(SoapClientHandlerInterface soapClientHandler, OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider, OAuth2AuthorizationHeaderProvider oAuth2AuthorizationHeaderProvider, DfpApiConfiguration dfpApiConfiguration, DfpBuildConfiguration dfpBuildConfiguration) {
        this.oAuthAuthorizationHeaderProvider = oAuthAuthorizationHeaderProvider;
        this.oAuth2AuthorizationHeaderProvider = oAuth2AuthorizationHeaderProvider;
        this.soapClientHandler = soapClientHandler;
        this.dfpApiConfiguration = dfpApiConfiguration;
        this.dfpBuildConfiguration = dfpBuildConfiguration;
    }

    @Override
    public void setHeaders(Object soapClient, DfpSession dfpSession, DfpServiceDescriptor dfpServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            Object soapHeader = this.createSoapHeader(dfpServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"applicationName", (Object)(String.valueOf(this.generateLibSignature()) + "|" + dfpSession.getApplicationName()));
            if (dfpSession.getNetworkCode() != null) {
                BeanUtils.setProperty((Object)soapHeader, (String)"networkCode", (Object)dfpSession.getNetworkCode());
            }
            this.setAuthenticationHeaders(dfpServiceDescriptor, soapClient, soapHeader, dfpSession);
            String namespace = String.valueOf(this.dfpApiConfiguration.getNamespacePrefix()) + "/" + dfpServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(soapClient, namespace, "RequestHeader", soapHeader);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
    }

    String generateLibSignature() {
        return String.valueOf(this.dfpBuildConfiguration.getLibPrefix()) + "-" + this.dfpBuildConfiguration.getLibPostfix() + "-" + this.dfpBuildConfiguration.getLibVersion();
    }

    @VisibleForTesting
    void setAuthenticationHeaders(DfpServiceDescriptor dfpServiceDescriptor, Object soapClient, Object soapHeader, DfpSession dfpSession) throws IllegalAccessException, InvocationTargetException, OAuthException, ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, NoSuchMethodException {
        if (dfpSession.getClientLoginToken() != null) {
            BeanUtils.setProperty((Object)soapHeader, (String)"authentication", (Object)this.createClientLoginObject(dfpServiceDescriptor, dfpSession));
        } else if (dfpSession.getOAuthParameters() != null) {
            String authorizationHeader = this.oAuthAuthorizationHeaderProvider.getOAuthAuthorizationHeader(dfpSession, new GenericUrl(this.soapClientHandler.getEndpointAddress(soapClient)));
            this.soapClientHandler.setHttpHeaders(soapClient, (Map<String, String>)new HashMap<String, String>(authorizationHeader){
                {
                    this.put("Authorization", string);
                }
            });
        } else if (dfpSession.getOAuth2Credential() != null) {
            String authorizationHeader = this.oAuth2AuthorizationHeaderProvider.getOAuth2AuthorizationHeader(dfpSession);
            this.soapClientHandler.setHttpHeaders(soapClient, (Map<String, String>)new HashMap<String, String>(authorizationHeader){
                {
                    this.put("Authorization", string);
                }
            });
        }
    }

    @VisibleForTesting
    Object createSoapHeader(DfpServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> interfaceClass = adsServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        return Class.forName(String.valueOf(packageName) + ".SoapRequestHeader").newInstance();
    }

    @VisibleForTesting
    Object createClientLoginObject(DfpServiceDescriptor dfpServiceDescriptor, DfpSession dfpSession) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        Class<?> interfaceClass = dfpServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        Class<?> clientLoginClass = Class.forName(String.valueOf(packageName) + "." + "ClientLogin");
        return clientLoginClass.getConstructor(String.class, String.class).newInstance(null, dfpSession.getClientLoginToken());
    }
}

