/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFieldExtractor {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private DocumentBuilder builder;
    private XPath xpath;

    public XmlFieldExtractor() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Couldn't construct a DocumentBuilder", e);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public Map<String, String> extract(InputStream xml, String[] fields) {
        HashMap parsedFields = Maps.newHashMap();
        try {
            Document doc = this.getDocument(xml);
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                try {
                    String value = this.extract(doc, field);
                    if (value != null) {
                        parsedFields.put(field, value);
                    }
                }
                catch (XPathExpressionException e) {
                    logger.warn("While processing xml, XPath invalid.", (Throwable)e);
                }
                ++n2;
            }
        }
        catch (SAXException e) {
            logger.error("Couldn't process XML into a Document", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Problem reading input stream", (Throwable)e);
        }
        return parsedFields;
    }

    @Nullable
    private String extract(Document doc, String field) throws XPathExpressionException {
        XPathExpression expr = this.xpath.compile("//" + field);
        NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            return nl.item(0).getTextContent();
        }
        return null;
    }

    @VisibleForTesting
    Document getDocument(InputStream is) throws SAXException, IOException {
        return this.builder.parse(is);
    }
}

