/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.soap.ProductFrameworkModule;
import com.google.api.ads.common.lib.utils.logging.AdsServiceLoggers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

@Deprecated
public class FactoryConfiguration {
    private ProductFrameworkModule adWordsSoapModule;
    private ProductFrameworkModule dfaSoapModule;
    private ProductFrameworkModule dfpSoapModule;

    private FactoryConfiguration() {
    }

    public ProductFrameworkModule getAdWordsSoapModule() {
        return this.adWordsSoapModule;
    }

    public ProductFrameworkModule getDfaSoapModule() {
        return this.dfaSoapModule;
    }

    public ProductFrameworkModule getDfpSoapModule() {
        return this.dfpSoapModule;
    }

    /* synthetic */ FactoryConfiguration(FactoryConfiguration factoryConfiguration) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<FactoryConfiguration> {
        private FactoryConfiguration factoryConfiguration = new FactoryConfiguration(null);
        private String adWordsSoapModuleClassString;
        private String dfaSoapModuleClassString;
        private String dfpSoapModuleClassString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            String dfpSoapModuleClassString;
            String dfaSoapModuleClassString;
            String adWordsSoapModuleClassString = config.getString("api.adwords.soapModule", null);
            if (adWordsSoapModuleClassString != null) {
                this.adWordsSoapModuleClassString = adWordsSoapModuleClassString;
            }
            if ((dfaSoapModuleClassString = config.getString("api.dfa.soapModule", null)) != null) {
                this.dfaSoapModuleClassString = dfaSoapModuleClassString;
            }
            if ((dfpSoapModuleClassString = config.getString("api.dfp.soapModule", null)) != null) {
                this.dfpSoapModuleClassString = dfpSoapModuleClassString;
            }
            return this;
        }

        public Builder withAdWordsSoapModule(ProductFrameworkModule soapModuleClass) {
            this.factoryConfiguration.adWordsSoapModule = soapModuleClass;
            return this;
        }

        public Builder withDfaSoapModule(ProductFrameworkModule soapModuleClass) {
            this.factoryConfiguration.dfaSoapModule = soapModuleClass;
            return this;
        }

        public Builder withDfpSoapModule(ProductFrameworkModule soapModuleClass) {
            this.factoryConfiguration.dfpSoapModule = soapModuleClass;
            return this;
        }

        @Nullable
        public FactoryConfiguration buildDefault() {
            FactoryConfiguration factoryConfiguration = null;
            try {
                factoryConfiguration = new Builder().fromFile().build();
            }
            catch (ConfigurationLoadException e) {
                if (!(Throwables.getRootCause((Throwable)e) instanceof ConfigurationException)) {
                    throw new IllegalStateException(e);
                }
            }
            catch (ValidationException e) {
                throw new IllegalStateException("A SOAP module specified in your properties file is invalid.", e);
            }
            return factoryConfiguration;
        }

        @Override
        public FactoryConfiguration build() throws ValidationException {
            try {
                this.from((Configuration)this.configHelper.createCombinedConfiguration(ConfigurationHelper.newList(Lists.newArrayList((Object[])new String[]{"ads.properties"}), true), null));
            }
            catch (ConfigurationLoadException configurationLoadException) {
                AdsServiceLoggers.ADS_API_LIB_LOG.debug("Factory configuration could not be loaded.");
            }
            this.validate(this.factoryConfiguration);
            return this.factoryConfiguration;
        }

        private ProductFrameworkModule classNameToObject(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return (ProductFrameworkModule)((Object)Class.forName(className).newInstance());
        }

        private void validate(FactoryConfiguration factoryConfiguration) throws ValidationException {
            if (this.adWordsSoapModuleClassString != null) {
                try {
                    factoryConfiguration.adWordsSoapModule = this.classNameToObject(this.adWordsSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.adWordsSoapModuleClassString, "api.adwords.soapModule", e);
                }
                catch (InstantiationException e) {
                    throw new ValidationException("Cannot instantiate an object of class: " + this.adWordsSoapModuleClassString, "api.adwords.soapModule", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidationException("Cannot access class: " + this.adWordsSoapModuleClassString, "api.adwords.soapModule", e);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Given class is not a valid SOAP module class: " + this.adWordsSoapModuleClassString, "api.adwords.soapModule", e);
                }
            }
            if (this.dfaSoapModuleClassString != null) {
                try {
                    factoryConfiguration.dfaSoapModule = this.classNameToObject(this.dfaSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.dfaSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (InstantiationException e) {
                    throw new ValidationException("Cannot instantiate an object of class: " + this.dfaSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidationException("Cannot access class: " + this.dfaSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Given class is not a valid SOAP module class: " + this.dfaSoapModuleClassString, "api.dfa.soapModule", e);
                }
            }
            if (this.dfpSoapModuleClassString != null) {
                try {
                    factoryConfiguration.dfpSoapModule = this.classNameToObject(this.dfpSoapModuleClassString);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Cannot find SOAP module class: " + this.dfpSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (InstantiationException e) {
                    throw new ValidationException("Cannot instantiate an object of class: " + this.dfpSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidationException("Cannot access class: " + this.dfpSoapModuleClassString, "api.dfa.soapModule", e);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Given class is not a valid SOAP module class: " + this.dfpSoapModuleClassString, "api.dfp.soapModule", e);
                }
            }
        }
    }
}

