/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.AwqlWriter;
import com.google.api.ads.adwords.lib.utils.RawReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportDefinitionWriter;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportUrlConnectionHelper;
import com.google.api.ads.adwords.lib.utils.ReportWriter;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocReportDownloadHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(AdHocReportDownloadHelper.class.getPackage().getName()) + ".report_download"));
    private final AdWordsSession session;
    private final ReportUrlConnectionHelper reportUrlConnectionHelper;
    private final String version;

    public AdHocReportDownloadHelper(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportUrlConnectionHelper = new ReportUrlConnectionHelper(session);
    }

    public RawReportDownloadResponse downloadReport(String reportDefinitionXml) throws ReportException {
        return this.downloadReport(new ReportDefinitionWriter(reportDefinitionXml));
    }

    public RawReportDownloadResponse downloadReport(String reportQuery, String format) throws ReportException {
        return this.downloadReport(new AwqlWriter(reportQuery, format));
    }

    protected RawReportDownloadResponse downloadReport(ReportWriter reportWriter) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(this.version);
            HttpURLConnection conn = this.reportUrlConnectionHelper.getReportHttpUrlConnection(downloadUrl);
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            logger.info("Content-type: {}", (Object)"application/x-www-form-urlencoded");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            reportWriter.write(conn.getOutputStream());
            logger.info(reportWriter.getReportParameters());
            int status = conn.getResponseCode();
            InputStream inputStream = null;
            if (status == 200) {
                logger.info(conn.getResponseMessage());
                this.logResponseHeaders(conn.getHeaderFields(), true);
                inputStream = conn.getInputStream();
            } else {
                logger.warn(conn.getResponseMessage());
                this.logResponseHeaders(conn.getHeaderFields(), false);
                inputStream = conn.getErrorStream();
            }
            return new RawReportDownloadResponse(status, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
        catch (AuthenticationException e) {
            throw new ReportException("Unable to authenticate.", e);
        }
    }

    @VisibleForTesting
    void logResponseHeaders(Map<String, List<String>> headerFields, boolean success) {
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            String headerName = header.getKey();
            for (String value : header.getValue()) {
                if (success) {
                    logger.info("{}: {}", (Object)headerName, (Object)value);
                    continue;
                }
                logger.warn("{}: {}", (Object)headerName, (Object)value);
            }
        }
    }

    @VisibleForTesting
    String generateReportUrl(String version) {
        return String.valueOf(this.session.getEndpoint()) + "/api/adwords/reportdownload" + '/' + version;
    }
}

