/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.client;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.adwords.lib.conf.AdWordsBuildConfiguration;
import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import com.google.api.client.http.GenericUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdWordsJaxWsHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    private static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final SoapClientHandlerInterface<Object> soapClientHandler;
    private final OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider;
    private final AdWordsApiConfiguration adWordsApiConfiguration;
    private final AdWordsBuildConfiguration adWordsBuildConfiguration;

    @Inject
    public AdWordsJaxWsHeaderHandler(SoapClientHandlerInterface soapClientHandler, OAuthAuthorizationHeaderProvider oAuthAuthorizationHeaderProvider, AdWordsApiConfiguration adWordsApiConfiguration, AdWordsBuildConfiguration adWordsBuildConfiguration) {
        this.oAuthAuthorizationHeaderProvider = oAuthAuthorizationHeaderProvider;
        this.soapClientHandler = soapClientHandler;
        this.adWordsApiConfiguration = adWordsApiConfiguration;
        this.adWordsBuildConfiguration = adWordsBuildConfiguration;
    }

    @Override
    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws AuthenticationException, ServiceException {
        Map<String, Object> headerData = this.readHeaderElements(adWordsSession);
        this.setAuthenticationHeaders(soapClient, headerData, adWordsSession);
        this.soapClientHandler.setHeader(soapClient, null, null, this.constructSoapHeader(headerData, adWordsServiceDescriptor));
    }

    @VisibleForTesting
    void setAuthenticationHeaders(Object soapClient, Map<String, Object> headerElements, AdWordsSession adWordsSession) throws OAuthException {
        if (adWordsSession.getClientLoginToken() != null) {
            headerElements.put("authToken", adWordsSession.getClientLoginToken());
        } else if (adWordsSession.getOAuthParameters() != null) {
            String authorizationHeader = this.oAuthAuthorizationHeaderProvider.getOAuthAuthorizationHeader(adWordsSession, new GenericUrl(this.soapClientHandler.getEndpointAddress(soapClient)));
            this.soapClientHandler.setHttpHeaders(soapClient, (Map<String, String>)new HashMap<String, String>(authorizationHeader){
                {
                    this.put("Authorization", string);
                }
            });
        }
    }

    private Map<String, Object> readHeaderElements(AdWordsSession adWordsSession) {
        Map mapToFill = Maps.newHashMap();
        mapToFill.put("developerToken", adWordsSession.getDeveloperToken());
        mapToFill.put("clientCustomerId", adWordsSession.getClientCustomerId());
        mapToFill.put("userAgent", String.valueOf(this.generateLibSignature()) + "|" + adWordsSession.getUserAgent());
        mapToFill.put("validateOnly", adWordsSession.isValidateOnly());
        mapToFill.put("partialFailure", adWordsSession.isPartialFailure());
        return mapToFill;
    }

    String generateLibSignature() {
        return String.valueOf(this.adWordsBuildConfiguration.getLibPrefix()) + "-" + this.adWordsBuildConfiguration.getLibPostfix() + "-" + this.adWordsBuildConfiguration.getLibVersion();
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, AdWordsServiceDescriptor adWordsServiceDescriptor) {
        String namespace = String.valueOf(this.adWordsApiConfiguration.getNamespacePrefix()) + "/" + adWordsServiceDescriptor.getPackageGroup() + "/" + adWordsServiceDescriptor.getVersion();
        String requestHeaderNamespace = String.valueOf(this.adWordsApiConfiguration.getNamespacePrefix()) + "/cm/" + adWordsServiceDescriptor.getVersion();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(new QName(namespace, REQUEST_HEADER_LOCAL_PART));
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, null, requestHeaderNamespace);
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception.", e);
        }
    }
}

