/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.lib.factory;

import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.common.lib.factory.FactoryConfiguration;
import com.google.api.ads.dfa.lib.DfaModule;
import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.api.ads.dfa.lib.factory.DfaServiceClientFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfaServices {
    private DfaServiceClientFactory factory;

    public DfaServices() {
        FactoryConfiguration factoryConfiguration = null;
        try {
            factoryConfiguration = new FactoryConfiguration.Builder().fromFile().build();
        }
        catch (IllegalArgumentException e) {
            if (!(Throwables.getRootCause((Throwable)e) instanceof ConfigurationException)) {
                throw new IllegalStateException(e);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("A SOAP module specified in your properties file is invalid.", e);
        }
        this.factory = factoryConfiguration == null ? new DfaServiceClientFactory() : new DfaServiceClientFactory(new DfaModule(factoryConfiguration));
    }

    @VisibleForTesting
    DfaServices(DfaServiceClientFactory factory) {
        this.factory = factory;
    }

    public DfaServices(FactoryConfiguration factoryConfiguration) {
        this.factory = new DfaServiceClientFactory(new DfaModule(factoryConfiguration));
    }

    public <T> T get(DfaSession dfaSession, Class<T> interfaceClass) {
        return this.factory.getServiceClientAsInterface(dfaSession, interfaceClass);
    }
}

