/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.security.GeneralSecurityException;

public class OAuthAuthorizationHeaderProvider {
    private final String requestMethod;

    @Inject
    public OAuthAuthorizationHeaderProvider(@Named(value="requestMethod") String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getOAuthAuthorizationHeader(OAuthParameters oAuthParameters, GenericUrl requestUrl) throws OAuthException {
        try {
            oAuthParameters.computeNonce();
            oAuthParameters.computeTimestamp();
            oAuthParameters.computeSignature(this.requestMethod, requestUrl);
            return oAuthParameters.getAuthorizationHeader();
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException("Unexpected exception occurred.", e);
        }
    }
}

