/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib;

import com.google.api.ads.common.lib.auth.OAuthAuthorizationHeaderProvider;
import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.factory.FactoryModule;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.api.ads.common.lib.utils.logging.LoggingModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsModule<C extends AdsServiceClient<S, D>, D extends AdsServiceDescriptor, S extends AdsSession>
extends AbstractModule {
    private Reflections reflections;

    public AdsModule() {
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().include("com\\.google\\.api\\.ads\\..*Module.*")).setUrls((Collection)ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[0])));
    }

    @VisibleForTesting
    AdsModule(Reflections reflections) {
        this.reflections = reflections;
    }

    protected void configure() {
        this.configureAuthentication();
    }

    protected void configureAuthentication() {
        this.bind(OAuthAuthorizationHeaderProvider.class);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"requestMethod")).toInstance((Object)"POST");
    }

    protected void configureSoap(Class<?> moduleFromFactoryConfiguration, Class<? extends Annotation> moduleAnnotationClass) {
        Class soapClientHandlerModuleClass = null;
        if (moduleFromFactoryConfiguration != null) {
            soapClientHandlerModuleClass = moduleFromFactoryConfiguration;
        } else {
            Set modulesOnClasspath = this.reflections.getTypesAnnotatedWith(moduleAnnotationClass);
            if (modulesOnClasspath.isEmpty()) {
                throw new IllegalStateException("Unable to locate a SOAP module by reflection. Did you forget to add a plugin specifying which SOAP framework to use with the library?");
            }
            if (modulesOnClasspath.size() > 1) {
                throw new IllegalStateException("Located more than one SOAP module on the classpath. Did you add more than one plugin specifying which SOAP framework to use with the library?");
            }
            soapClientHandlerModuleClass = (Class)modulesOnClasspath.iterator().next();
        }
        try {
            this.install((Module)((AbstractModule)soapClientHandlerModuleClass.newInstance()));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate SOAP module by reflection. Did you add the correct plugin specifying which SOAP framework to use with the library?", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to instantiate SOAP module by reflection. Did you add the correct plugin specifying which SOAP framework to use with the library?", e);
        }
    }

    protected void configureLogging(String loggerPrefix) {
        this.install((Module)new LoggingModule(loggerPrefix));
    }

    protected <H extends AdsServiceClientFactoryHelper<C, S, D>> void configureFactories(TypeLiteral adsServiceClientFactoryTypeLiteral, TypeLiteral adsServiceDescriptorFactoryTypeLiteral, TypeLiteral adsServiceClientTypeLiteral, TypeLiteral adsServiceDescriptorTypeLiteral, Class<H> factoryHelperClass, Class<?> factoryClass) {
        this.install((Module)new FactoryModule(adsServiceClientFactoryTypeLiteral, adsServiceDescriptorFactoryTypeLiteral, adsServiceClientTypeLiteral, adsServiceDescriptorTypeLiteral, factoryHelperClass, factoryClass));
    }
}

