/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class StreamUtils {
    private static final int BUFFER_SIZE = 1024;

    public InputStream wrapString(String str) {
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 should be supported.");
        }
    }

    public String readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.copy(inputStream, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public void write(String str, OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(outputStream));
        writer.write(str);
        writer.close();
    }

    public void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        try {
            int i = 0;
            byte[] buffer = new byte[1024];
            while ((i = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, i);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

