/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.auth;

import com.google.api.ads.common.lib.auth.CaptchaInformation;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.exception.ClientLoginException;
import com.google.api.ads.common.lib.utils.StreamUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoginTokens {
    public static final String ADWORDS_SERVICE = "adwords";
    public static final String DFP_SERVICE = "gam";
    private static final String ADWORDS_PROP_KEY_PREFIX = "api.adwords.";
    private static final String DFP_PROP_KEY_PREFIX = "api.dfp.";
    private static final String RESOURCE_PROPERTIES_NAME = "ads.properties";
    private static final int HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final String AUTH_TOKEN_KEY = "Auth";
    private static final String ERROR_KEY = "Error";
    private static final String URL_KEY = "Url";
    private static final String CAPTCHA_TOKEN_KEY = "CaptchaToken";
    private static final String CAPTCHA_URL_KEY = "CaptchaUrl";
    private static final String CAPTCHA_REQUIRED_ERROR = "CaptchaRequired";
    private static final String DEFAULT_CLIENT_LOGIN_SERVER_URL = "https://www.google.com/accounts/ClientLogin";
    private static final String INFO_KEY = "Info";
    private final String service;
    private final String source = "Ads-Api-Java-Lib";
    private static String clientLoginServerUrl = "https://www.google.com/accounts/ClientLogin";
    private ConfigurationHelper configHelper;

    @VisibleForTesting
    String getPropertyKey(String suffix) {
        if (ADWORDS_SERVICE.equalsIgnoreCase(this.service)) {
            return ADWORDS_PROP_KEY_PREFIX + suffix;
        }
        if (DFP_SERVICE.equalsIgnoreCase(this.service)) {
            return DFP_PROP_KEY_PREFIX + suffix;
        }
        return suffix;
    }

    public ClientLoginTokens(String service) {
        this.service = service;
        this.configHelper = new ConfigurationHelper();
    }

    @VisibleForTesting
    ClientLoginTokens(String service, ConfigurationHelper helper) {
        this.service = service;
        this.configHelper = helper;
    }

    public String fromFile() throws ClientLoginException {
        return this.fromFile(RESOURCE_PROPERTIES_NAME);
    }

    public String fromFile(String path) throws ClientLoginException {
        return this.from(this.configHelper.fromFile(path));
    }

    public String fromFile(File path) throws ClientLoginException {
        return this.from(this.configHelper.fromFile(path));
    }

    public String fromFile(URL path) throws ClientLoginException {
        return this.from(this.configHelper.fromFile(path));
    }

    public String from(Configuration config) throws ClientLoginException {
        if (config.getString(this.getPropertyKey("clientLoginToken")) != null) {
            return config.getString(this.getPropertyKey("clientLoginToken"));
        }
        if (config.getString(this.getPropertyKey("email")) != null && config.getString(this.getPropertyKey("password")) != null) {
            return this.from(config.getString(this.getPropertyKey("email")), config.getString(this.getPropertyKey("password")));
        }
        throw new IllegalArgumentException("Expected Configuration to contain either a clientLoginToken or an email and password.");
    }

    public String from(String email, String password) throws ClientLoginException {
        return this.from(email, password, null, null);
    }

    public String from(String email, String password, String loginToken, String loginCaptcha) throws ClientLoginException {
        return this.requestAuthToken(email, password, loginToken, loginCaptcha);
    }

    private String requestAuthToken(String email, String password, String loginToken, String loginCaptcha) throws ClientLoginException {
        String clientLoginToken = this.requestToken(email, password, loginToken, loginCaptcha);
        return clientLoginToken;
    }

    private String requestToken(String email, String password, String loginToken, String loginCaptcha) throws ClientLoginException {
        try {
            HttpsURLConnection conn = this.postToClientLogin(email, password, loginToken, loginCaptcha);
            int statusCode = conn.getResponseCode();
            String responseBody = new StreamUtils().readAll(statusCode == 200 ? conn.getInputStream() : conn.getErrorStream());
            Properties responseProperties = ClientLoginTokens.generatePropertiesFromResponse(new StreamUtils().wrapString(responseBody));
            if (statusCode == 200) {
                if (responseProperties.containsKey(AUTH_TOKEN_KEY)) {
                    return responseProperties.getProperty(AUTH_TOKEN_KEY).toString();
                }
                throw new IllegalStateException("Unable to get auth token from Client Login server");
            }
            CaptchaInformation captchaInfo = null;
            String errorCode = null;
            if (responseProperties.containsKey(ERROR_KEY)) {
                errorCode = responseProperties.getProperty(ERROR_KEY);
                if (errorCode != null && errorCode.equals(CAPTCHA_REQUIRED_ERROR)) {
                    captchaInfo = ClientLoginTokens.extractCaptchaInfoFromProperties(responseProperties);
                }
                if (responseProperties.getProperty(INFO_KEY) != null) {
                    errorCode = String.valueOf(errorCode) + ": " + responseProperties.getProperty(INFO_KEY);
                }
            }
            throw new ClientLoginException(statusCode, responseBody, errorCode, captchaInfo, null);
        }
        catch (IOException e) {
            throw new ClientLoginException(null, null, null, null, e);
        }
    }

    private HttpsURLConnection postToClientLogin(String email, String password, String loginToken, String loginCaptcha) throws IOException {
        HttpsURLConnection conn = this.getConnection(clientLoginServerUrl, "POST");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("Email", email);
        params.put("Passwd", password);
        params.put("accountType", "GOOGLE");
        params.put("service", this.service);
        params.put("source", "Ads-Api-Java-Lib");
        if (loginToken != null) {
            params.put("logintoken", loginToken);
        }
        if (loginCaptcha != null) {
            params.put("logincaptcha", loginCaptcha);
        }
        String payload = this.generateParamsPayload(params);
        new StreamUtils().write(payload, conn.getOutputStream());
        conn.connect();
        return conn;
    }

    private HttpsURLConnection getConnection(String clientLoginServerUrl, String requestMethod) throws IOException {
        HttpsURLConnection conn = (HttpsURLConnection)new URL(clientLoginServerUrl).openConnection();
        conn.setConnectTimeout(HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS);
        conn.setRequestMethod(requestMethod);
        if ("POST".equalsIgnoreCase(requestMethod)) {
            conn.setDoOutput(true);
        }
        return conn;
    }

    private String generateParamsPayload(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 should be a supported encoding.", e);
            }
        }
        return sb.toString();
    }

    private static CaptchaInformation extractCaptchaInfoFromProperties(Properties authProperties) {
        String captchaUrl = String.valueOf(clientLoginServerUrl) + authProperties.getProperty(CAPTCHA_URL_KEY);
        String captchaToken = authProperties.getProperty(CAPTCHA_TOKEN_KEY);
        String url = authProperties.getProperty(URL_KEY);
        return new CaptchaInformation(captchaUrl, captchaToken, url);
    }

    private static Properties generatePropertiesFromResponse(InputStream responseBodyStream) throws IOException {
        Properties properties = new Properties();
        properties.load(responseBodyStream);
        return properties;
    }
}

