/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxws;

import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.RequestInfoXPathSet;
import com.google.api.ads.common.lib.soap.ResponseInfoXPathSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class JaxWsSoapContextHandler
implements SOAPHandler<SOAPMessageContext> {
    private RequestInfo.Builder lastRequestInfo;
    private ResponseInfo.Builder lastResponseInfo;
    private Set<SOAPElement> soapHeaders = new HashSet<SOAPElement>();
    private final RequestInfoXPathSet requestInfoXPathSet;
    private final ResponseInfoXPathSet responseInfoXPathSet;

    @Inject
    public JaxWsSoapContextHandler(RequestInfoXPathSet requestInfoXPathSet, ResponseInfoXPathSet responseInfoXPathSet) {
        this.requestInfoXPathSet = requestInfoXPathSet;
        this.responseInfoXPathSet = responseInfoXPathSet;
        this.lastRequestInfo = new RequestInfo.Builder();
        this.lastResponseInfo = new ResponseInfo.Builder();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            this.lastRequestInfo = new RequestInfo.Builder();
            this.lastResponseInfo = new ResponseInfo.Builder();
            SOAPMessage soapMessage = context.getMessage();
            try {
                SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                if (soapHeader == null) {
                    soapHeader = soapMessage.getSOAPPart().getEnvelope().addHeader();
                }
                for (SOAPElement header : this.soapHeaders) {
                    soapHeader.addChildElement(header);
                }
            }
            catch (SOAPException e) {
                throw new ServiceException("Error setting SOAP headers on outbound message.", (Throwable)e);
            }
            this.captureServiceAndOperationNames(context);
        }
        this.captureSoapXml(context);
        return true;
    }

    @VisibleForTesting
    void captureServiceAndOperationNames(SOAPMessageContext context) {
        String lastOperationCalled;
        this.lastRequestInfo.withServiceName(((QName)context.get((Object)"javax.xml.ws.wsdl.service")).getLocalPart());
        try {
            lastOperationCalled = context.getMessage().getSOAPBody().getFirstChild().getLocalName();
        }
        catch (SOAPException e) {
            lastOperationCalled = "";
        }
        this.lastRequestInfo.withMethodName(lastOperationCalled);
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.captureSoapXml(context);
        return true;
    }

    private void captureSoapXml(SOAPMessageContext context) {
        SOAPMessage message = context.getMessage();
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            this.requestInfoXPathSet.parseMessage(this.lastRequestInfo, message);
        } else {
            this.responseInfoXPathSet.parseMessage(this.lastResponseInfo, message);
        }
    }

    public RequestInfo.Builder getLastRequestInfoBuilder() {
        return this.lastRequestInfo;
    }

    public ResponseInfo.Builder getLastResponseInfoBuilder() {
        return this.lastResponseInfo;
    }

    public void addHeader(String namespace, String headerName, SOAPElement headerValue) {
        this.soapHeaders.add(headerValue);
    }

    public void clearHeaders() {
        this.soapHeaders.clear();
    }

    public Set<SOAPElement> getAddedHeaders() {
        return this.soapHeaders;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }
}

