/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetOrderRequest;
import com.google.ads.admanager.v1.ListOrdersRequest;
import com.google.ads.admanager.v1.ListOrdersResponse;
import com.google.ads.admanager.v1.Order;
import com.google.ads.admanager.v1.OrderServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonOrderServiceStub;
import com.google.ads.admanager.v1.stub.OrderServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class OrderServiceStubSettings
extends StubSettings<OrderServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetOrderRequest, Order> getOrderSettings;
    private final PagedCallSettings<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse> listOrdersSettings;
    private static final PagedListDescriptor<ListOrdersRequest, ListOrdersResponse, Order> LIST_ORDERS_PAGE_STR_DESC = new PagedListDescriptor<ListOrdersRequest, ListOrdersResponse, Order>(){

        public String emptyToken() {
            return "";
        }

        public ListOrdersRequest injectToken(ListOrdersRequest payload, String token) {
            return ListOrdersRequest.newBuilder((ListOrdersRequest)payload).setPageToken(token).build();
        }

        public ListOrdersRequest injectPageSize(ListOrdersRequest payload, int pageSize) {
            return ListOrdersRequest.newBuilder((ListOrdersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrdersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrdersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Order> extractResources(ListOrdersResponse payload) {
            return payload.getOrdersList() == null ? ImmutableList.of() : payload.getOrdersList();
        }
    };
    private static final PagedListResponseFactory<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse> LIST_ORDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse>(){

        public ApiFuture<OrderServiceClient.ListOrdersPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrdersRequest, ListOrdersResponse> callable, ListOrdersRequest request, ApiCallContext context, ApiFuture<ListOrdersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrderServiceClient.ListOrdersPagedResponse.createAsync((PageContext<ListOrdersRequest, ListOrdersResponse, Order>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetOrderRequest, Order> getOrderSettings() {
        return this.getOrderSettings;
    }

    public PagedCallSettings<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse> listOrdersSettings() {
        return this.listOrdersSettings;
    }

    public OrderServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOrderServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OrderServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OrderServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OrderServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getOrderSettings = settingsBuilder.getOrderSettings().build();
        this.listOrdersSettings = settingsBuilder.listOrdersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OrderServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetOrderRequest, Order> getOrderSettings;
        private final PagedCallSettings.Builder<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse> listOrdersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getOrderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOrdersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORDERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOrderSettings, this.listOrdersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OrderServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getOrderSettings = settings.getOrderSettings.toBuilder();
            this.listOrdersSettings = settings.listOrdersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOrderSettings, this.listOrdersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OrderServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OrderServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OrderServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OrderServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getOrderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrdersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetOrderRequest, Order> getOrderSettings() {
            return this.getOrderSettings;
        }

        public PagedCallSettings.Builder<ListOrdersRequest, ListOrdersResponse, OrderServiceClient.ListOrdersPagedResponse> listOrdersSettings() {
            return this.listOrdersSettings;
        }

        public OrderServiceStubSettings build() throws IOException {
            return new OrderServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

