/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetOrderRequest;
import com.google.ads.admanager.v1.ListOrdersRequest;
import com.google.ads.admanager.v1.ListOrdersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Order;
import com.google.ads.admanager.v1.OrderName;
import com.google.ads.admanager.v1.OrderServiceSettings;
import com.google.ads.admanager.v1.stub.OrderServiceStub;
import com.google.ads.admanager.v1.stub.OrderServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OrderServiceClient
implements BackgroundResource {
    private final OrderServiceSettings settings;
    private final OrderServiceStub stub;

    public static final OrderServiceClient create() throws IOException {
        return OrderServiceClient.create(OrderServiceSettings.newBuilder().build());
    }

    public static final OrderServiceClient create(OrderServiceSettings settings) throws IOException {
        return new OrderServiceClient(settings);
    }

    public static final OrderServiceClient create(OrderServiceStub stub) {
        return new OrderServiceClient(stub);
    }

    protected OrderServiceClient(OrderServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OrderServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected OrderServiceClient(OrderServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OrderServiceSettings getSettings() {
        return this.settings;
    }

    public OrderServiceStub getStub() {
        return this.stub;
    }

    public final Order getOrder(OrderName name) {
        GetOrderRequest request = GetOrderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrder(request);
    }

    public final Order getOrder(String name) {
        GetOrderRequest request = GetOrderRequest.newBuilder().setName(name).build();
        return this.getOrder(request);
    }

    public final Order getOrder(GetOrderRequest request) {
        return (Order)this.getOrderCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrderRequest, Order> getOrderCallable() {
        return this.stub.getOrderCallable();
    }

    public final ListOrdersPagedResponse listOrders(NetworkName parent) {
        ListOrdersRequest request = ListOrdersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOrders(request);
    }

    public final ListOrdersPagedResponse listOrders(String parent) {
        ListOrdersRequest request = ListOrdersRequest.newBuilder().setParent(parent).build();
        return this.listOrders(request);
    }

    public final ListOrdersPagedResponse listOrders(ListOrdersRequest request) {
        return (ListOrdersPagedResponse)((Object)this.listOrdersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersPagedResponse> listOrdersPagedCallable() {
        return this.stub.listOrdersPagedCallable();
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable() {
        return this.stub.listOrdersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListOrdersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        private ListOrdersFixedSizeCollection(List<ListOrdersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrdersFixedSizeCollection createEmptyCollection() {
            return new ListOrdersFixedSizeCollection(null, 0);
        }

        protected ListOrdersFixedSizeCollection createCollection(List<ListOrdersPage> pages, int collectionSize) {
            return new ListOrdersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrdersPage
    extends AbstractPage<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage> {
        private ListOrdersPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            super(context, (Object)response);
        }

        private static ListOrdersPage createEmptyPage() {
            return new ListOrdersPage(null, null);
        }

        protected ListOrdersPage createPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            return new ListOrdersPage(context, response);
        }

        public ApiFuture<ListOrdersPage> createPageAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrdersPagedResponse
    extends AbstractPagedListResponse<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        public static ApiFuture<ListOrdersPagedResponse> createAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            ApiFuture<ListOrdersPage> futurePage = ListOrdersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrdersPagedResponse((ListOrdersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrdersPagedResponse(ListOrdersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrdersFixedSizeCollection.createEmptyCollection());
        }
    }
}

