/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.AdUnit;
import com.google.ads.admanager.v1.AdUnitName;
import com.google.ads.admanager.v1.AdUnitServiceSettings;
import com.google.ads.admanager.v1.GetAdUnitRequest;
import com.google.ads.admanager.v1.ListAdUnitsRequest;
import com.google.ads.admanager.v1.ListAdUnitsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.AdUnitServiceStub;
import com.google.ads.admanager.v1.stub.AdUnitServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AdUnitServiceClient
implements BackgroundResource {
    private final AdUnitServiceSettings settings;
    private final AdUnitServiceStub stub;

    public static final AdUnitServiceClient create() throws IOException {
        return AdUnitServiceClient.create(AdUnitServiceSettings.newBuilder().build());
    }

    public static final AdUnitServiceClient create(AdUnitServiceSettings settings) throws IOException {
        return new AdUnitServiceClient(settings);
    }

    public static final AdUnitServiceClient create(AdUnitServiceStub stub) {
        return new AdUnitServiceClient(stub);
    }

    protected AdUnitServiceClient(AdUnitServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdUnitServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdUnitServiceClient(AdUnitServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdUnitServiceSettings getSettings() {
        return this.settings;
    }

    public AdUnitServiceStub getStub() {
        return this.stub;
    }

    public final AdUnit getAdUnit(AdUnitName name) {
        GetAdUnitRequest request = GetAdUnitRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAdUnit(request);
    }

    public final AdUnit getAdUnit(String name) {
        GetAdUnitRequest request = GetAdUnitRequest.newBuilder().setName(name).build();
        return this.getAdUnit(request);
    }

    public final AdUnit getAdUnit(GetAdUnitRequest request) {
        return (AdUnit)this.getAdUnitCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdUnitRequest, AdUnit> getAdUnitCallable() {
        return this.stub.getAdUnitCallable();
    }

    public final ListAdUnitsPagedResponse listAdUnits(NetworkName parent) {
        ListAdUnitsRequest request = ListAdUnitsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdUnits(request);
    }

    public final ListAdUnitsPagedResponse listAdUnits(String parent) {
        ListAdUnitsRequest request = ListAdUnitsRequest.newBuilder().setParent(parent).build();
        return this.listAdUnits(request);
    }

    public final ListAdUnitsPagedResponse listAdUnits(ListAdUnitsRequest request) {
        return (ListAdUnitsPagedResponse)((Object)this.listAdUnitsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdUnitsRequest, ListAdUnitsPagedResponse> listAdUnitsPagedCallable() {
        return this.stub.listAdUnitsPagedCallable();
    }

    public final UnaryCallable<ListAdUnitsRequest, ListAdUnitsResponse> listAdUnitsCallable() {
        return this.stub.listAdUnitsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAdUnitsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit, ListAdUnitsPage, ListAdUnitsFixedSizeCollection> {
        private ListAdUnitsFixedSizeCollection(List<ListAdUnitsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdUnitsFixedSizeCollection createEmptyCollection() {
            return new ListAdUnitsFixedSizeCollection(null, 0);
        }

        protected ListAdUnitsFixedSizeCollection createCollection(List<ListAdUnitsPage> pages, int collectionSize) {
            return new ListAdUnitsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdUnitsPage
    extends AbstractPage<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit, ListAdUnitsPage> {
        private ListAdUnitsPage(PageContext<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit> context, ListAdUnitsResponse response) {
            super(context, (Object)response);
        }

        private static ListAdUnitsPage createEmptyPage() {
            return new ListAdUnitsPage(null, null);
        }

        protected ListAdUnitsPage createPage(PageContext<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit> context, ListAdUnitsResponse response) {
            return new ListAdUnitsPage(context, response);
        }

        public ApiFuture<ListAdUnitsPage> createPageAsync(PageContext<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit> context, ApiFuture<ListAdUnitsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdUnitsPagedResponse
    extends AbstractPagedListResponse<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit, ListAdUnitsPage, ListAdUnitsFixedSizeCollection> {
        public static ApiFuture<ListAdUnitsPagedResponse> createAsync(PageContext<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit> context, ApiFuture<ListAdUnitsResponse> futureResponse) {
            ApiFuture<ListAdUnitsPage> futurePage = ListAdUnitsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdUnitsPagedResponse((ListAdUnitsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdUnitsPagedResponse(ListAdUnitsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdUnitsFixedSizeCollection.createEmptyCollection());
        }
    }
}

