/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetTeamRequest;
import com.google.ads.admanager.v1.ListTeamsRequest;
import com.google.ads.admanager.v1.ListTeamsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Team;
import com.google.ads.admanager.v1.TeamName;
import com.google.ads.admanager.v1.TeamServiceSettings;
import com.google.ads.admanager.v1.stub.TeamServiceStub;
import com.google.ads.admanager.v1.stub.TeamServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TeamServiceClient
implements BackgroundResource {
    private final TeamServiceSettings settings;
    private final TeamServiceStub stub;

    public static final TeamServiceClient create() throws IOException {
        return TeamServiceClient.create(TeamServiceSettings.newBuilder().build());
    }

    public static final TeamServiceClient create(TeamServiceSettings settings) throws IOException {
        return new TeamServiceClient(settings);
    }

    public static final TeamServiceClient create(TeamServiceStub stub) {
        return new TeamServiceClient(stub);
    }

    protected TeamServiceClient(TeamServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TeamServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected TeamServiceClient(TeamServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TeamServiceSettings getSettings() {
        return this.settings;
    }

    public TeamServiceStub getStub() {
        return this.stub;
    }

    public final Team getTeam(TeamName name) {
        GetTeamRequest request = GetTeamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTeam(request);
    }

    public final Team getTeam(String name) {
        GetTeamRequest request = GetTeamRequest.newBuilder().setName(name).build();
        return this.getTeam(request);
    }

    public final Team getTeam(GetTeamRequest request) {
        return (Team)this.getTeamCallable().call((Object)request);
    }

    public final UnaryCallable<GetTeamRequest, Team> getTeamCallable() {
        return this.stub.getTeamCallable();
    }

    public final ListTeamsPagedResponse listTeams(NetworkName parent) {
        ListTeamsRequest request = ListTeamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTeams(request);
    }

    public final ListTeamsPagedResponse listTeams(String parent) {
        ListTeamsRequest request = ListTeamsRequest.newBuilder().setParent(parent).build();
        return this.listTeams(request);
    }

    public final ListTeamsPagedResponse listTeams(ListTeamsRequest request) {
        return (ListTeamsPagedResponse)((Object)this.listTeamsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTeamsRequest, ListTeamsPagedResponse> listTeamsPagedCallable() {
        return this.stub.listTeamsPagedCallable();
    }

    public final UnaryCallable<ListTeamsRequest, ListTeamsResponse> listTeamsCallable() {
        return this.stub.listTeamsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTeamsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTeamsRequest, ListTeamsResponse, Team, ListTeamsPage, ListTeamsFixedSizeCollection> {
        private ListTeamsFixedSizeCollection(List<ListTeamsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTeamsFixedSizeCollection createEmptyCollection() {
            return new ListTeamsFixedSizeCollection(null, 0);
        }

        protected ListTeamsFixedSizeCollection createCollection(List<ListTeamsPage> pages, int collectionSize) {
            return new ListTeamsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTeamsPage
    extends AbstractPage<ListTeamsRequest, ListTeamsResponse, Team, ListTeamsPage> {
        private ListTeamsPage(PageContext<ListTeamsRequest, ListTeamsResponse, Team> context, ListTeamsResponse response) {
            super(context, (Object)response);
        }

        private static ListTeamsPage createEmptyPage() {
            return new ListTeamsPage(null, null);
        }

        protected ListTeamsPage createPage(PageContext<ListTeamsRequest, ListTeamsResponse, Team> context, ListTeamsResponse response) {
            return new ListTeamsPage(context, response);
        }

        public ApiFuture<ListTeamsPage> createPageAsync(PageContext<ListTeamsRequest, ListTeamsResponse, Team> context, ApiFuture<ListTeamsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTeamsPagedResponse
    extends AbstractPagedListResponse<ListTeamsRequest, ListTeamsResponse, Team, ListTeamsPage, ListTeamsFixedSizeCollection> {
        public static ApiFuture<ListTeamsPagedResponse> createAsync(PageContext<ListTeamsRequest, ListTeamsResponse, Team> context, ApiFuture<ListTeamsResponse> futureResponse) {
            ApiFuture<ListTeamsPage> futurePage = ListTeamsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTeamsPagedResponse((ListTeamsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTeamsPagedResponse(ListTeamsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTeamsFixedSizeCollection.createEmptyCollection());
        }
    }
}

