/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreatePrivateAuctionDealRequest;
import com.google.ads.admanager.v1.GetPrivateAuctionDealRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionDealsRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionDealsResponse;
import com.google.ads.admanager.v1.PrivateAuctionDeal;
import com.google.ads.admanager.v1.PrivateAuctionDealServiceClient;
import com.google.ads.admanager.v1.UpdatePrivateAuctionDealRequest;
import com.google.ads.admanager.v1.stub.HttpJsonPrivateAuctionDealServiceStub;
import com.google.ads.admanager.v1.stub.PrivateAuctionDealServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PrivateAuctionDealServiceStubSettings
extends StubSettings<PrivateAuctionDealServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetPrivateAuctionDealRequest, PrivateAuctionDeal> getPrivateAuctionDealSettings;
    private final PagedCallSettings<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> listPrivateAuctionDealsSettings;
    private final UnaryCallSettings<CreatePrivateAuctionDealRequest, PrivateAuctionDeal> createPrivateAuctionDealSettings;
    private final UnaryCallSettings<UpdatePrivateAuctionDealRequest, PrivateAuctionDeal> updatePrivateAuctionDealSettings;
    private static final PagedListDescriptor<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal> LIST_PRIVATE_AUCTION_DEALS_PAGE_STR_DESC = new PagedListDescriptor<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal>(){

        public String emptyToken() {
            return "";
        }

        public ListPrivateAuctionDealsRequest injectToken(ListPrivateAuctionDealsRequest payload, String token) {
            return ListPrivateAuctionDealsRequest.newBuilder((ListPrivateAuctionDealsRequest)payload).setPageToken(token).build();
        }

        public ListPrivateAuctionDealsRequest injectPageSize(ListPrivateAuctionDealsRequest payload, int pageSize) {
            return ListPrivateAuctionDealsRequest.newBuilder((ListPrivateAuctionDealsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPrivateAuctionDealsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPrivateAuctionDealsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PrivateAuctionDeal> extractResources(ListPrivateAuctionDealsResponse payload) {
            return payload.getPrivateAuctionDealsList();
        }
    };
    private static final PagedListResponseFactory<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> LIST_PRIVATE_AUCTION_DEALS_PAGE_STR_FACT = new PagedListResponseFactory<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse>(){

        public ApiFuture<PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse> callable, ListPrivateAuctionDealsRequest request, ApiCallContext context, ApiFuture<ListPrivateAuctionDealsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRIVATE_AUCTION_DEALS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse.createAsync((PageContext<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetPrivateAuctionDealRequest, PrivateAuctionDeal> getPrivateAuctionDealSettings() {
        return this.getPrivateAuctionDealSettings;
    }

    public PagedCallSettings<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> listPrivateAuctionDealsSettings() {
        return this.listPrivateAuctionDealsSettings;
    }

    public UnaryCallSettings<CreatePrivateAuctionDealRequest, PrivateAuctionDeal> createPrivateAuctionDealSettings() {
        return this.createPrivateAuctionDealSettings;
    }

    public UnaryCallSettings<UpdatePrivateAuctionDealRequest, PrivateAuctionDeal> updatePrivateAuctionDealSettings() {
        return this.updatePrivateAuctionDealSettings;
    }

    public PrivateAuctionDealServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPrivateAuctionDealServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PrivateAuctionDealServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivateAuctionDealServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PrivateAuctionDealServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getPrivateAuctionDealSettings = settingsBuilder.getPrivateAuctionDealSettings().build();
        this.listPrivateAuctionDealsSettings = settingsBuilder.listPrivateAuctionDealsSettings().build();
        this.createPrivateAuctionDealSettings = settingsBuilder.createPrivateAuctionDealSettings().build();
        this.updatePrivateAuctionDealSettings = settingsBuilder.updatePrivateAuctionDealSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PrivateAuctionDealServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetPrivateAuctionDealRequest, PrivateAuctionDeal> getPrivateAuctionDealSettings;
        private final PagedCallSettings.Builder<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> listPrivateAuctionDealsSettings;
        private final UnaryCallSettings.Builder<CreatePrivateAuctionDealRequest, PrivateAuctionDeal> createPrivateAuctionDealSettings;
        private final UnaryCallSettings.Builder<UpdatePrivateAuctionDealRequest, PrivateAuctionDeal> updatePrivateAuctionDealSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getPrivateAuctionDealSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPrivateAuctionDealsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRIVATE_AUCTION_DEALS_PAGE_STR_FACT);
            this.createPrivateAuctionDealSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePrivateAuctionDealSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPrivateAuctionDealSettings, this.listPrivateAuctionDealsSettings, this.createPrivateAuctionDealSettings, this.updatePrivateAuctionDealSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PrivateAuctionDealServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getPrivateAuctionDealSettings = settings.getPrivateAuctionDealSettings.toBuilder();
            this.listPrivateAuctionDealsSettings = settings.listPrivateAuctionDealsSettings.toBuilder();
            this.createPrivateAuctionDealSettings = settings.createPrivateAuctionDealSettings.toBuilder();
            this.updatePrivateAuctionDealSettings = settings.updatePrivateAuctionDealSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPrivateAuctionDealSettings, this.listPrivateAuctionDealsSettings, this.createPrivateAuctionDealSettings, this.updatePrivateAuctionDealSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PrivateAuctionDealServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PrivateAuctionDealServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivateAuctionDealServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PrivateAuctionDealServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getPrivateAuctionDealSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPrivateAuctionDealsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createPrivateAuctionDealSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updatePrivateAuctionDealSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetPrivateAuctionDealRequest, PrivateAuctionDeal> getPrivateAuctionDealSettings() {
            return this.getPrivateAuctionDealSettings;
        }

        public PagedCallSettings.Builder<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDealServiceClient.ListPrivateAuctionDealsPagedResponse> listPrivateAuctionDealsSettings() {
            return this.listPrivateAuctionDealsSettings;
        }

        public UnaryCallSettings.Builder<CreatePrivateAuctionDealRequest, PrivateAuctionDeal> createPrivateAuctionDealSettings() {
            return this.createPrivateAuctionDealSettings;
        }

        public UnaryCallSettings.Builder<UpdatePrivateAuctionDealRequest, PrivateAuctionDeal> updatePrivateAuctionDealSettings() {
            return this.updatePrivateAuctionDealSettings;
        }

        public PrivateAuctionDealServiceStubSettings build() throws IOException {
            return new PrivateAuctionDealServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

