/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetMobileDeviceSubmodelRequest;
import com.google.ads.admanager.v1.ListMobileDeviceSubmodelsRequest;
import com.google.ads.admanager.v1.ListMobileDeviceSubmodelsResponse;
import com.google.ads.admanager.v1.MobileDeviceSubmodel;
import com.google.ads.admanager.v1.MobileDeviceSubmodelServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonMobileDeviceSubmodelServiceStub;
import com.google.ads.admanager.v1.stub.MobileDeviceSubmodelServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MobileDeviceSubmodelServiceStubSettings
extends StubSettings<MobileDeviceSubmodelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetMobileDeviceSubmodelRequest, MobileDeviceSubmodel> getMobileDeviceSubmodelSettings;
    private final PagedCallSettings<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> listMobileDeviceSubmodelsSettings;
    private static final PagedListDescriptor<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel> LIST_MOBILE_DEVICE_SUBMODELS_PAGE_STR_DESC = new PagedListDescriptor<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel>(){

        public String emptyToken() {
            return "";
        }

        public ListMobileDeviceSubmodelsRequest injectToken(ListMobileDeviceSubmodelsRequest payload, String token) {
            return ListMobileDeviceSubmodelsRequest.newBuilder((ListMobileDeviceSubmodelsRequest)payload).setPageToken(token).build();
        }

        public ListMobileDeviceSubmodelsRequest injectPageSize(ListMobileDeviceSubmodelsRequest payload, int pageSize) {
            return ListMobileDeviceSubmodelsRequest.newBuilder((ListMobileDeviceSubmodelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMobileDeviceSubmodelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMobileDeviceSubmodelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MobileDeviceSubmodel> extractResources(ListMobileDeviceSubmodelsResponse payload) {
            return payload.getMobileDeviceSubmodelsList();
        }
    };
    private static final PagedListResponseFactory<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> LIST_MOBILE_DEVICE_SUBMODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse>(){

        public ApiFuture<MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse> callable, ListMobileDeviceSubmodelsRequest request, ApiCallContext context, ApiFuture<ListMobileDeviceSubmodelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MOBILE_DEVICE_SUBMODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse.createAsync((PageContext<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetMobileDeviceSubmodelRequest, MobileDeviceSubmodel> getMobileDeviceSubmodelSettings() {
        return this.getMobileDeviceSubmodelSettings;
    }

    public PagedCallSettings<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> listMobileDeviceSubmodelsSettings() {
        return this.listMobileDeviceSubmodelsSettings;
    }

    public MobileDeviceSubmodelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMobileDeviceSubmodelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MobileDeviceSubmodelServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MobileDeviceSubmodelServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MobileDeviceSubmodelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getMobileDeviceSubmodelSettings = settingsBuilder.getMobileDeviceSubmodelSettings().build();
        this.listMobileDeviceSubmodelsSettings = settingsBuilder.listMobileDeviceSubmodelsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MobileDeviceSubmodelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetMobileDeviceSubmodelRequest, MobileDeviceSubmodel> getMobileDeviceSubmodelSettings;
        private final PagedCallSettings.Builder<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> listMobileDeviceSubmodelsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getMobileDeviceSubmodelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMobileDeviceSubmodelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MOBILE_DEVICE_SUBMODELS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileDeviceSubmodelSettings, this.listMobileDeviceSubmodelsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MobileDeviceSubmodelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getMobileDeviceSubmodelSettings = settings.getMobileDeviceSubmodelSettings.toBuilder();
            this.listMobileDeviceSubmodelsSettings = settings.listMobileDeviceSubmodelsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileDeviceSubmodelSettings, this.listMobileDeviceSubmodelsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MobileDeviceSubmodelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MobileDeviceSubmodelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MobileDeviceSubmodelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MobileDeviceSubmodelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getMobileDeviceSubmodelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMobileDeviceSubmodelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetMobileDeviceSubmodelRequest, MobileDeviceSubmodel> getMobileDeviceSubmodelSettings() {
            return this.getMobileDeviceSubmodelSettings;
        }

        public PagedCallSettings.Builder<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodelServiceClient.ListMobileDeviceSubmodelsPagedResponse> listMobileDeviceSubmodelsSettings() {
            return this.listMobileDeviceSubmodelsSettings;
        }

        public MobileDeviceSubmodelServiceStubSettings build() throws IOException {
            return new MobileDeviceSubmodelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

