/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetMobileDeviceRequest;
import com.google.ads.admanager.v1.ListMobileDevicesRequest;
import com.google.ads.admanager.v1.ListMobileDevicesResponse;
import com.google.ads.admanager.v1.MobileDevice;
import com.google.ads.admanager.v1.MobileDeviceServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonMobileDeviceServiceStub;
import com.google.ads.admanager.v1.stub.MobileDeviceServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MobileDeviceServiceStubSettings
extends StubSettings<MobileDeviceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetMobileDeviceRequest, MobileDevice> getMobileDeviceSettings;
    private final PagedCallSettings<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse> listMobileDevicesSettings;
    private static final PagedListDescriptor<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice> LIST_MOBILE_DEVICES_PAGE_STR_DESC = new PagedListDescriptor<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice>(){

        public String emptyToken() {
            return "";
        }

        public ListMobileDevicesRequest injectToken(ListMobileDevicesRequest payload, String token) {
            return ListMobileDevicesRequest.newBuilder((ListMobileDevicesRequest)payload).setPageToken(token).build();
        }

        public ListMobileDevicesRequest injectPageSize(ListMobileDevicesRequest payload, int pageSize) {
            return ListMobileDevicesRequest.newBuilder((ListMobileDevicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMobileDevicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMobileDevicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MobileDevice> extractResources(ListMobileDevicesResponse payload) {
            return payload.getMobileDevicesList();
        }
    };
    private static final PagedListResponseFactory<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse> LIST_MOBILE_DEVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse>(){

        public ApiFuture<MobileDeviceServiceClient.ListMobileDevicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMobileDevicesRequest, ListMobileDevicesResponse> callable, ListMobileDevicesRequest request, ApiCallContext context, ApiFuture<ListMobileDevicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MOBILE_DEVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MobileDeviceServiceClient.ListMobileDevicesPagedResponse.createAsync((PageContext<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetMobileDeviceRequest, MobileDevice> getMobileDeviceSettings() {
        return this.getMobileDeviceSettings;
    }

    public PagedCallSettings<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse> listMobileDevicesSettings() {
        return this.listMobileDevicesSettings;
    }

    public MobileDeviceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMobileDeviceServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MobileDeviceServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MobileDeviceServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MobileDeviceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getMobileDeviceSettings = settingsBuilder.getMobileDeviceSettings().build();
        this.listMobileDevicesSettings = settingsBuilder.listMobileDevicesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MobileDeviceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetMobileDeviceRequest, MobileDevice> getMobileDeviceSettings;
        private final PagedCallSettings.Builder<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse> listMobileDevicesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getMobileDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMobileDevicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MOBILE_DEVICES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileDeviceSettings, this.listMobileDevicesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MobileDeviceServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getMobileDeviceSettings = settings.getMobileDeviceSettings.toBuilder();
            this.listMobileDevicesSettings = settings.listMobileDevicesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMobileDeviceSettings, this.listMobileDevicesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MobileDeviceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MobileDeviceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MobileDeviceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MobileDeviceServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getMobileDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMobileDevicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetMobileDeviceRequest, MobileDevice> getMobileDeviceSettings() {
            return this.getMobileDeviceSettings;
        }

        public PagedCallSettings.Builder<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDeviceServiceClient.ListMobileDevicesPagedResponse> listMobileDevicesSettings() {
            return this.listMobileDevicesSettings;
        }

        public MobileDeviceServiceStubSettings build() throws IOException {
            return new MobileDeviceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

