/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchCreateContactsRequest;
import com.google.ads.admanager.v1.BatchCreateContactsResponse;
import com.google.ads.admanager.v1.BatchUpdateContactsRequest;
import com.google.ads.admanager.v1.BatchUpdateContactsResponse;
import com.google.ads.admanager.v1.Contact;
import com.google.ads.admanager.v1.ContactServiceClient;
import com.google.ads.admanager.v1.CreateContactRequest;
import com.google.ads.admanager.v1.GetContactRequest;
import com.google.ads.admanager.v1.ListContactsRequest;
import com.google.ads.admanager.v1.ListContactsResponse;
import com.google.ads.admanager.v1.UpdateContactRequest;
import com.google.ads.admanager.v1.stub.ContactServiceStub;
import com.google.ads.admanager.v1.stub.ContactServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonContactServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonContactServiceStub
extends ContactServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetContactRequest, Contact> getContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/GetContact").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/contacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListContactsRequest, ListContactsResponse> listContactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/ListContacts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contacts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListContactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateContactRequest, Contact> createContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/CreateContact").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contacts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("contact", (Message)request.getContact(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchCreateContactsRequest, BatchCreateContactsResponse> batchCreateContactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/BatchCreateContacts").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contacts:batchCreate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchCreateContactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateContactRequest, Contact> updateContactMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/UpdateContact").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{contact.name=networks/*/contacts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "contact.name", (Object)request.getContact().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("contact", (Message)request.getContact(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Contact.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchUpdateContactsRequest, BatchUpdateContactsResponse> batchUpdateContactsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ContactService/BatchUpdateContacts").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/contacts:batchUpdate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchUpdateContactsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetContactRequest, Contact> getContactCallable;
    private final UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable;
    private final UnaryCallable<ListContactsRequest, ContactServiceClient.ListContactsPagedResponse> listContactsPagedCallable;
    private final UnaryCallable<CreateContactRequest, Contact> createContactCallable;
    private final UnaryCallable<BatchCreateContactsRequest, BatchCreateContactsResponse> batchCreateContactsCallable;
    private final UnaryCallable<UpdateContactRequest, Contact> updateContactCallable;
    private final UnaryCallable<BatchUpdateContactsRequest, BatchUpdateContactsResponse> batchUpdateContactsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonContactServiceStub create(ContactServiceStubSettings settings) throws IOException {
        return new HttpJsonContactServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonContactServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonContactServiceStub(ContactServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonContactServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonContactServiceStub(ContactServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonContactServiceStub(ContactServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonContactServiceCallableFactory());
    }

    protected HttpJsonContactServiceStub(ContactServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getContactMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listContactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listContactsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createContactMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchCreateContactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchCreateContactsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateContactTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateContactMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("contact.name", String.valueOf(request.getContact().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchUpdateContactsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchUpdateContactsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getContactCallable = callableFactory.createUnaryCallable(getContactTransportSettings, settings.getContactSettings(), clientContext);
        this.listContactsCallable = callableFactory.createUnaryCallable(listContactsTransportSettings, settings.listContactsSettings(), clientContext);
        this.listContactsPagedCallable = callableFactory.createPagedCallable(listContactsTransportSettings, settings.listContactsSettings(), clientContext);
        this.createContactCallable = callableFactory.createUnaryCallable(createContactTransportSettings, settings.createContactSettings(), clientContext);
        this.batchCreateContactsCallable = callableFactory.createUnaryCallable(batchCreateContactsTransportSettings, settings.batchCreateContactsSettings(), clientContext);
        this.updateContactCallable = callableFactory.createUnaryCallable(updateContactTransportSettings, settings.updateContactSettings(), clientContext);
        this.batchUpdateContactsCallable = callableFactory.createUnaryCallable(batchUpdateContactsTransportSettings, settings.batchUpdateContactsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getContactMethodDescriptor);
        methodDescriptors.add(listContactsMethodDescriptor);
        methodDescriptors.add(createContactMethodDescriptor);
        methodDescriptors.add(batchCreateContactsMethodDescriptor);
        methodDescriptors.add(updateContactMethodDescriptor);
        methodDescriptors.add(batchUpdateContactsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetContactRequest, Contact> getContactCallable() {
        return this.getContactCallable;
    }

    @Override
    public UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable() {
        return this.listContactsCallable;
    }

    @Override
    public UnaryCallable<ListContactsRequest, ContactServiceClient.ListContactsPagedResponse> listContactsPagedCallable() {
        return this.listContactsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateContactRequest, Contact> createContactCallable() {
        return this.createContactCallable;
    }

    @Override
    public UnaryCallable<BatchCreateContactsRequest, BatchCreateContactsResponse> batchCreateContactsCallable() {
        return this.batchCreateContactsCallable;
    }

    @Override
    public UnaryCallable<UpdateContactRequest, Contact> updateContactCallable() {
        return this.updateContactCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateContactsRequest, BatchUpdateContactsResponse> batchUpdateContactsCallable() {
        return this.batchUpdateContactsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

